/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.i18n;

import com.jfinal.i18n.Res;
import com.jfinal.kit.StrKit;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class I18n {
    static String defaultBaseName = "i18n";
    static String defaultLocale = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
    private static final ConcurrentHashMap<String, Res> resMap = new ConcurrentHashMap();

    private I18n() {
    }

    public static void setDefaultBaseName(String defaultBaseName) {
        if (StrKit.isBlank(defaultBaseName)) {
            throw new IllegalArgumentException("defaultBaseName can not be blank.");
        }
        I18n.defaultBaseName = defaultBaseName;
    }

    public static void setDefaultLocale(String defaultLocale) {
        if (StrKit.isBlank(defaultLocale)) {
            throw new IllegalArgumentException("defaultLocale can not be blank.");
        }
        I18n.defaultLocale = defaultLocale;
    }

    public static Res use(String baseName, String locale) {
        String resKey = baseName + locale;
        Res res = resMap.get(resKey);
        if (res == null) {
            res = new Res(baseName, locale);
            resMap.put(resKey, res);
        }
        return res;
    }

    public static Res use(String baseName, Locale locale) {
        return I18n.use(baseName, I18n.toLocale(locale));
    }

    public static Res use(String locale) {
        return I18n.use(defaultBaseName, locale);
    }

    public static Res use() {
        return I18n.use(defaultBaseName, defaultLocale);
    }

    public static Locale toLocale(String locale) {
        String[] array = locale.split("_");
        if (array.length == 1) {
            return new Locale(array[0]);
        }
        return new Locale(array[0], array[1]);
    }

    public static String toLocale(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry();
    }
}

