/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.core.converter.TypeConverter;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Injector {
    private static <T> T createInstance(Class<T> objClass) {
        try {
            return objClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectModel(Class<T> modelClass, HttpServletRequest request, boolean skipConvertError) {
        String modelName = modelClass.getSimpleName();
        return Injector.injectModel(modelClass, StrKit.firstCharToLowerCase(modelName), request, skipConvertError);
    }

    public static <T> T injectBean(Class<T> beanClass, HttpServletRequest request, boolean skipConvertError) {
        String beanName = beanClass.getSimpleName();
        return Injector.injectBean(beanClass, StrKit.firstCharToLowerCase(beanName), request, skipConvertError);
    }

    public static final <T> T injectBean(Class<T> beanClass, String beanName, HttpServletRequest request, boolean skipConvertError) {
        Method[] methods;
        T bean = Injector.createInstance(beanClass);
        String modelNameAndDot = StrKit.notBlank(beanName) ? beanName + "." : null;
        TypeConverter converter = TypeConverter.me();
        Map parasMap = request.getParameterMap();
        for (Method method : methods = beanClass.getMethods()) {
            String paraName;
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() <= 3 || (types = method.getParameterTypes()).length != 1) continue;
            String attrName = StrKit.firstCharToLowerCase(methodName.substring(3));
            String string = paraName = modelNameAndDot != null ? modelNameAndDot + attrName : attrName;
            if (!parasMap.containsKey(paraName)) continue;
            try {
                String paraValue = request.getParameter(paraName);
                Object value = paraValue != null ? converter.convert(types[0], paraValue) : null;
                method.invoke(bean, value);
            }
            catch (Exception e) {
                if (skipConvertError) continue;
                throw new RuntimeException(e);
            }
        }
        return bean;
    }

    public static final <T> T injectModel(Class<T> modelClass, String modelName, HttpServletRequest request, boolean skipConvertError) {
        T temp = Injector.createInstance(modelClass);
        if (!(temp instanceof Model)) {
            throw new IllegalArgumentException("getModel only support class of Model, using getBean for other class.");
        }
        Model model = (Model)temp;
        Table table = TableMapping.me().getTable(model.getClass());
        if (table == null) {
            throw new ActiveRecordException("The Table mapping of model: " + modelClass.getName() + " not exists or the ActiveRecordPlugin not start.");
        }
        String modelNameAndDot = StrKit.notBlank(modelName) ? modelName + "." : null;
        Map parasMap = request.getParameterMap();
        TypeConverter converter = TypeConverter.me();
        for (Map.Entry entry : parasMap.entrySet()) {
            String attrName;
            String paraName = (String)entry.getKey();
            if (modelNameAndDot != null) {
                if (!paraName.startsWith(modelNameAndDot)) continue;
                attrName = paraName.substring(modelNameAndDot.length());
            } else {
                attrName = paraName;
            }
            Class<?> colType = table.getColumnType(attrName);
            if (colType == null) {
                if (skipConvertError) continue;
                throw new ActiveRecordException("The model attribute " + attrName + " is not exists.");
            }
            try {
                String[] paraValueArray = (String[])entry.getValue();
                String paraValue = paraValueArray != null && paraValueArray.length > 0 ? paraValueArray[0] : null;
                Object value = paraValue != null ? converter.convert(colType, paraValue) : null;
                model.set(attrName, value);
            }
            catch (Exception e) {
                if (skipConvertError) continue;
                throw new RuntimeException("Can not convert parameter: " + paraName, e);
            }
        }
        return (T)model;
    }
}

