/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import com.jfinal.wxaapp.api.WxaAccessTokenApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WxaSubscribeMsgApi {
    private static String addTemplateUrl = "https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate?access_token=";
    private static String delTemplateUrl = "https://api.weixin.qq.com/wxaapi/newtmpl/deltemplate?access_token=";
    private static String getCategoryUrl = "https://api.weixin.qq.com/wxaapi/newtmpl/getcategory?access_token=";
    private static String getPubTemplateKeyWordsUrl = "https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatekeywords?access_token=";
    private static String getPubTemplateTitlesUrl = "https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatetitles?access_token=";
    private static String getTemplateUrl = "https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate?access_token=";
    private static String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=";

    public static ApiResult addTemplate(String tid, ArrayList<Integer> kidList, String sceneDesc) {
        String accessToken = WxaAccessTokenApi.getAccessTokenStr();
        Kv kv = Kv.by((Object)"tid", (Object)tid).set((Object)"kidList", kidList);
        if (StrKit.notBlank((String)sceneDesc)) {
            kv.set((Object)"sceneDesc", (Object)sceneDesc);
        }
        String jsonResult = HttpUtils.post(addTemplateUrl + accessToken, JsonUtils.toJson(kv));
        return new ApiResult(jsonResult);
    }

    public static ApiResult delTemplate(String priTmplId) {
        String accessToken = WxaAccessTokenApi.getAccessTokenStr();
        Kv kv = Kv.by((Object)"priTmplId", (Object)priTmplId);
        String jsonResult = HttpUtils.post(delTemplateUrl + accessToken, JsonUtils.toJson(kv));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getCategory() {
        return new ApiResult(HttpUtils.get(getCategoryUrl + WxaAccessTokenApi.getAccessTokenStr()));
    }

    public static ApiResult getPubTemplateKeyWords(String tid) {
        Map<String, String> queryParas = ParaMap.create("tid", tid).getData();
        return new ApiResult(HttpUtils.get(getPubTemplateKeyWordsUrl + WxaAccessTokenApi.getAccessTokenStr(), queryParas));
    }

    public static ApiResult getPubTemplateTitles(String ids, String start, String limit) {
        Map<String, String> queryParas = ParaMap.create("ids", ids).put("start", StrKit.isBlank((String)start) ? "0" : start).put("limit", StrKit.isBlank((String)limit) ? "30" : limit).getData();
        return new ApiResult(HttpUtils.get(getPubTemplateTitlesUrl + WxaAccessTokenApi.getAccessTokenStr(), queryParas));
    }

    public static ApiResult getTemplate() {
        return new ApiResult(HttpUtils.get(getTemplateUrl + WxaAccessTokenApi.getAccessTokenStr()));
    }

    public static ApiResult send(String toUser, String templateId, SubTemplateItem data, String page) {
        String accessToken = WxaAccessTokenApi.getAccessTokenStr();
        Kv kv = Kv.by((Object)"touser", (Object)toUser).set((Object)"template_id", (Object)templateId).set((Object)"data", (Object)data);
        if (StrKit.notBlank((String)page)) {
            kv.set((Object)"page", (Object)page);
        }
        String jsonResult = HttpUtils.post(sendUrl + accessToken, JsonUtils.toJson(kv));
        return new ApiResult(jsonResult);
    }

    public class Item {
        private Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Item(Object value) {
            this.value = value;
        }
    }

    public class SubTemplateItem
    extends HashMap<String, Item> {
        private static final long serialVersionUID = -3728490424738325020L;

        public SubTemplateItem() {
        }

        public SubTemplateItem(String key, Item item) {
            this.put(key, item);
        }
    }
}

