/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.ApiConfigKit;
import java.util.Objects;
import java.util.function.Supplier;

public class Weixin {
    protected String appId;

    public static Weixin use(String appId) {
        Objects.requireNonNull(appId, "appId can not be null");
        return new Weixin(appId);
    }

    public static Weixin use() {
        return new Weixin(null);
    }

    Weixin(String appId) {
        this.appId = appId;
    }

    public <T> T call(Supplier<T> function) {
        if (this.appId != null) {
            try {
                ApiConfigKit.setThreadLocalAppId(this.appId);
                T t = function.get();
                return t;
            }
            finally {
                ApiConfigKit.removeThreadLocalAppId();
            }
        }
        return function.get();
    }
}

