/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.JsonKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.Content;
import com.jfinal.weixin.sdk.api.Data;
import com.jfinal.weixin.sdk.api.SubscribeInfo;
import com.jfinal.weixin.sdk.utils.Charsets;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class SubscribeMsgApi {
    private static String subscribe = "https://api.weixin.qq.com/cgi-bin/message/template/subscribe?access_token=";
    private static String authorize_uri = "https://mp.weixin.qq.com/mp/subscribemsg?action=get_confirm";

    public static String getAuthorizeURL(String scene, String template_id, String redirectUri, String reserved) throws UnsupportedEncodingException {
        StringBuffer sbf = new StringBuffer();
        sbf.append(authorize_uri).append("&appid=").append(ApiConfigKit.getAppId()).append("&scene=").append(scene).append("&template_id=").append(template_id).append("&redirect_uri=").append(URLEncoder.encode(redirectUri, Charsets.UTF_8.name()).replace("+", "%20"));
        if (StrKit.notBlank((String)reserved)) {
            sbf.append("&reserved=").append(reserved);
        }
        sbf.append("#wechat_redirect");
        return sbf.toString();
    }

    public static ApiResult subscribe(String jsonStr) {
        String jsonResult = HttpUtils.post(subscribe + AccessTokenApi.getAccessTokenStr(), jsonStr);
        return new ApiResult(jsonResult);
    }

    public static ApiResult subscribe(SubscribeInfo subscribeInfo) {
        return new ApiResult(JsonKit.toJson((Object)subscribeInfo));
    }

    public static ApiResult subscribe(String openId, String templateId, String url, int scene, String title, String value, String color) {
        SubscribeInfo subscribeInfo = SubscribeInfo.Builder().setTouser(openId).setTemplate_id(templateId).setUrl(url).setScene(String.valueOf(scene)).setTitle(title).setData(Data.Builder().setContent(Content.Builder().setValue(value).setColor(color).build()).build());
        return SubscribeMsgApi.subscribe(JsonUtils.toJson(subscribeInfo));
    }
}

