/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import com.jfinal.server.undertow.PathKitExt;
import com.jfinal.server.undertow.UndertowConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;

public class UndertowKit {
    private static String[] classPathDirs = null;
    private static Boolean deployMode = null;

    public static String[] getClassPathDirs() {
        if (classPathDirs == null) {
            classPathDirs = UndertowKit.buildClassPathDirs();
        }
        return classPathDirs;
    }

    private static String[] buildClassPathDirs() {
        String[] classPathArray;
        ArrayList<String> list = new ArrayList<String>();
        for (String classPath : classPathArray = System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file;
            if ((classPath = classPath.trim()).startsWith("./")) {
                classPath = classPath.substring(2);
            }
            if (!(file = new File(classPath)).exists() || !file.isDirectory()) continue;
            if (!classPath.endsWith(File.separator)) {
                classPath = classPath + File.separator;
            }
            list.add(classPath);
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean notAvailablePort(int port) {
        return !UndertowKit.isAvailablePort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailablePort(int port) {
        block6: {
            boolean bl;
            if (port <= 0) {
                throw new IllegalArgumentException("Invalid start port: " + port);
            }
            ServerSocket ss = null;
            DatagramSocket ds = null;
            try {
                ss = new ServerSocket(port);
                ss.setReuseAddress(true);
                ds = new DatagramSocket(port);
                ds.setReuseAddress(true);
                bl = true;
                UndertowKit.closeQuietly(ds);
            }
            catch (IOException e) {
                UndertowKit.doNothing(e);
                break block6;
            }
            finally {
                UndertowKit.closeQuietly(ds);
                UndertowKit.closeQuietly(ss);
            }
            UndertowKit.closeQuietly(ss);
            return bl;
        }
        return false;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            UndertowKit.doNothing(e);
        }
    }

    public static void doNothing(Throwable e) {
    }

    public static void configJFinalPathKit(UndertowConfig config) {
        try {
            UndertowKit.doConfigJFinalPathKit(config);
        }
        catch (Exception e) {
            UndertowKit.doNothing(e);
        }
    }

    private static void doConfigJFinalPathKit(UndertowConfig config) throws ReflectiveOperationException {
        Class<?> c = config.getClassLoader().loadClass("com.jfinal.kit.PathKit");
        Method setWebRootPath = c.getMethod("setWebRootPath", String.class);
        String webRootPath = PathKitExt.getWebRootPath();
        setWebRootPath.invoke(null, webRootPath);
        Method setRootClassPath = c.getMethod("setRootClassPath", String.class);
        String rootClassPath = PathKitExt.getRootClassPath();
        setRootClassPath.invoke(null, rootClassPath);
    }

    public static boolean isDeployMode() {
        if (deployMode == null) {
            deployMode = UndertowKit.buildDeployMode();
        }
        return deployMode;
    }

    public static boolean notDeployMode() {
        return !UndertowKit.isDeployMode();
    }

    private static boolean buildDeployMode() {
        String[] classPathDirs = UndertowKit.getClassPathDirs();
        if (classPathDirs != null && classPathDirs.length > 0) {
            for (String path : classPathDirs) {
                if (path == null || !(path = PathKitExt.removeSlashEnd(path)).endsWith("classes")) continue;
                return false;
            }
        }
        return true;
    }

    public String getAppBasePath() {
        String path = PathKitExt.getLocationPath();
        if (path.endsWith(File.separatorChar + "lib")) {
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        }
        return path;
    }

    public static String getJFinalVersion() {
        try {
            Class<?> clazz = Class.forName("com.jfinal.core.Const");
            Field field = clazz.getField("JFINAL_VERSION");
            return (String)field.get(null);
        }
        catch (Exception e) {
            return "5.0.0";
        }
    }
}

