/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.kit.TimeKit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Date;

public class TypeKit {
    private static final String datePattern = "yyyy-MM-dd";
    private static final int dateLen = "yyyy-MM-dd".length();
    private static final String dateTimeWithoutSecondPattern = "yyyy-MM-dd HH:mm";
    private static final int dateTimeWithoutSecondLen = "yyyy-MM-dd HH:mm".length();
    private static final String dateTimePattern = "yyyy-MM-dd HH:mm:ss";

    public static String toStr(Object s) {
        return s != null ? s.toString() : null;
    }

    public static Integer toInt(Object n) {
        if (n instanceof Integer) {
            return (Integer)n;
        }
        if (n instanceof Number) {
            return ((Number)n).intValue();
        }
        return n != null ? Integer.valueOf(Integer.parseInt(n.toString())) : null;
    }

    public static Long toLong(Object n) {
        if (n instanceof Long) {
            return (Long)n;
        }
        if (n instanceof Number) {
            return ((Number)n).longValue();
        }
        return n != null ? Long.valueOf(Long.parseLong(n.toString())) : null;
    }

    public static Double toDouble(Object n) {
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return n != null ? Double.valueOf(Double.parseDouble(n.toString())) : null;
    }

    public static BigDecimal toBigDecimal(Object n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n != null) {
            return new BigDecimal(n.toString());
        }
        return null;
    }

    public static Float toFloat(Object n) {
        if (n instanceof Float) {
            return (Float)n;
        }
        if (n instanceof Number) {
            return Float.valueOf(((Number)n).floatValue());
        }
        return n != null ? Float.valueOf(Float.parseFloat(n.toString())) : null;
    }

    public static Short toShort(Object n) {
        if (n instanceof Short) {
            return (Short)n;
        }
        if (n instanceof Number) {
            return ((Number)n).shortValue();
        }
        return n != null ? Short.valueOf(Short.parseShort(n.toString())) : null;
    }

    public static Byte toByte(Object n) {
        if (n instanceof Byte) {
            return (Byte)n;
        }
        if (n instanceof Number) {
            return ((Number)n).byteValue();
        }
        return n != null ? Byte.valueOf(Byte.parseByte(n.toString())) : null;
    }

    public static Boolean toBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b == null) {
            return null;
        }
        if (b instanceof Number) {
            if (b instanceof Integer || b instanceof Long || b instanceof BigInteger || b instanceof Byte || b instanceof Short) {
                int n = ((Number)b).intValue();
                if (n == 1) {
                    return Boolean.TRUE;
                }
                if (n == 0) {
                    return Boolean.FALSE;
                }
            }
            return (Boolean)b;
        }
        if (b instanceof String) {
            String s = b.toString();
            if ("true".equalsIgnoreCase(s) || "1".equals(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s) || "0".equals(s)) {
                return Boolean.FALSE;
            }
        }
        return (Boolean)b;
    }

    public static Number toNumber(Object n) {
        if (n instanceof Number) {
            return (Number)n;
        }
        if (n == null) {
            return null;
        }
        String s = n.toString();
        return s.indexOf(46) != -1 ? Double.parseDouble(s) : (double)Long.parseLong(s);
    }

    public static Date toDate(Object d) {
        if (d instanceof Date) {
            return (Date)d;
        }
        if (d instanceof Temporal) {
            if (d instanceof LocalDateTime) {
                return TimeKit.toDate((LocalDateTime)d);
            }
            if (d instanceof LocalDate) {
                return TimeKit.toDate((LocalDate)d);
            }
            if (d instanceof LocalTime) {
                return TimeKit.toDate((LocalTime)d);
            }
        }
        if (d instanceof String) {
            String s = (String)d;
            if (s.length() <= dateLen) {
                return TimeKit.parse(s, datePattern);
            }
            if (s.length() > dateTimeWithoutSecondLen) {
                return TimeKit.parse(s, dateTimePattern);
            }
            int index = s.indexOf(58);
            if (index != -1) {
                if (index != s.lastIndexOf(58)) {
                    return TimeKit.parse(s, dateTimePattern);
                }
                return TimeKit.parse(s, dateTimeWithoutSecondPattern);
            }
        }
        return (Date)d;
    }

    public static LocalDateTime toLocalDateTime(Object ldt) {
        if (ldt instanceof LocalDateTime) {
            return (LocalDateTime)ldt;
        }
        if (ldt instanceof LocalDate) {
            return ((LocalDate)ldt).atStartOfDay();
        }
        if (ldt instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)ldt);
        }
        if (ldt instanceof Date) {
            return TimeKit.toLocalDateTime((Date)ldt);
        }
        if (ldt instanceof String) {
            String s = (String)ldt;
            if (s.length() <= dateLen) {
                return TimeKit.parseLocalDateTime(s, datePattern);
            }
            if (s.length() > dateTimeWithoutSecondLen) {
                return TimeKit.parseLocalDateTime(s, dateTimePattern);
            }
            int index = s.indexOf(58);
            if (index != -1) {
                if (index != s.lastIndexOf(58)) {
                    return TimeKit.parseLocalDateTime(s, dateTimePattern);
                }
                return TimeKit.parseLocalDateTime(s, dateTimeWithoutSecondPattern);
            }
        }
        return (LocalDateTime)ldt;
    }
}

