/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat;

public class CharTable {
    private static final char NULL = '\u0000';
    private static final char EN_SIZE = '\u0080';
    private static final char CH_SIZE = '\u9fa6';
    private static char size = (char)128;
    private static char[] letterChars = CharTable.buildLetterChars();
    private static char[] letterOrDigitChars = CharTable.buildLetterOrDigitChars();
    private static char[] exprChars = CharTable.buildExprChars();

    private CharTable() {
    }

    public static void setChineseExpression(boolean enable) {
        size = enable ? (char)40870 : (char)128;
        letterChars = CharTable.buildLetterChars();
        letterOrDigitChars = CharTable.buildLetterOrDigitChars();
        exprChars = CharTable.buildExprChars();
    }

    private static void addChineseChar(char[] ret) {
        if (ret.length == 40870) {
            for (int i = 19968; i < 40870; i = (int)((char)(i + 1))) {
                ret[i] = i;
            }
        }
    }

    private static char[] createCharArray() {
        char[] ret = new char[size];
        for (char i = '\u0000'; i < size; i = (char)(i + '\u0001')) {
            ret[i] = '\u0000';
        }
        CharTable.addChineseChar(ret);
        return ret;
    }

    private static char[] buildLetterChars() {
        int i;
        char[] ret = CharTable.createCharArray();
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            ret[i] = i;
        }
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            ret[i] = i;
        }
        ret[95] = 95;
        return ret;
    }

    private static char[] buildLetterOrDigitChars() {
        char[] ret = CharTable.buildLetterChars();
        for (int i = 48; i <= 57; i = (int)((char)(i + 1))) {
            ret[i] = i;
        }
        return ret;
    }

    private static char[] buildExprChars() {
        char[] ret = CharTable.createCharArray();
        ret[9] = 9;
        ret[10] = 10;
        ret[13] = 13;
        for (int i = 32; i <= 125; i = (int)((char)(i + 1))) {
            ret[i] = i;
        }
        ret[35] = '\u0000';
        ret[36] = '\u0000';
        ret[64] = '\u0000';
        ret[92] = '\u0000';
        ret[94] = '\u0000';
        ret[96] = '\u0000';
        return ret;
    }

    public static boolean isLetter(char c) {
        return c < size && letterChars[c] != '\u0000';
    }

    public static boolean isLetterOrDigit(char c) {
        return c < size && letterOrDigitChars[c] != '\u0000';
    }

    public static boolean isExprChar(char c) {
        return c < size && exprChars[c] != '\u0000';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isBlank(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean isBlankOrLineFeed(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isHexadecimalDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }
}

