/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.proxy;

import com.jfinal.proxy.ProxyClass;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class ProxyCompiler {
    protected volatile List<String> options = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getOptions() {
        if (this.options != null) {
            return this.options;
        }
        ProxyCompiler proxyCompiler = this;
        synchronized (proxyCompiler) {
            if (this.options != null) {
                return this.options;
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("-target");
            ret.add("1.8");
            String cp = this.getClassPath();
            if (cp != null && cp.trim().length() != 0) {
                ret.add("-classpath");
                ret.add(cp);
            }
            this.options = ret;
            return this.options;
        }
    }

    protected String getClassPath() {
        URLClassLoader classLoader = this.getURLClassLoader();
        if (classLoader == null) {
            return null;
        }
        int index = 0;
        boolean isWindows = this.isWindows();
        StringBuilder ret = new StringBuilder();
        for (URL url : classLoader.getURLs()) {
            if (index++ > 0) {
                ret.append(File.pathSeparator);
            }
            String path = url.getFile();
            if (isWindows && path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 1 && (path.endsWith("/") || path.endsWith(File.separator))) {
                path = path.substring(0, path.length() - 1);
            }
            ret.append(path);
        }
        return ret.toString();
    }

    protected boolean isWindows() {
        String osName = System.getProperty("os.name", "unknown");
        return osName.toLowerCase().indexOf("windows") != -1;
    }

    protected URLClassLoader getURLClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        if (ret == null) {
            ret = ProxyCompiler.class.getClassLoader();
        }
        return ret instanceof URLClassLoader ? (URLClassLoader)ret : null;
    }

    public void compile(ProxyClass proxyClass) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new RuntimeException("Can not get javax.tools.JavaCompiler, check whether \"tools.jar\" is in the environment variable CLASSPATH");
        }
        DiagnosticCollector<JavaFileObject> collector = new DiagnosticCollector<JavaFileObject>();
        try (MyJavaFileManager javaFileManager = new MyJavaFileManager(compiler.getStandardFileManager(collector, null, null));){
            MyJavaFileObject javaFileObject = new MyJavaFileObject(proxyClass.getName(), proxyClass.getSourceCode());
            Boolean result = compiler.getTask(null, javaFileManager, collector, this.getOptions(), null, Arrays.asList(javaFileObject)).call();
            this.outputCompileError(result, collector);
            HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
            for (Map.Entry<String, MyJavaFileObject> e : javaFileManager.fileObjects.entrySet()) {
                ret.put(e.getKey(), e.getValue().getByteCode());
            }
            proxyClass.setByteCode(ret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void outputCompileError(Boolean result, DiagnosticCollector<JavaFileObject> collector) {
        if (!result.booleanValue()) {
            collector.getDiagnostics().forEach(item -> System.out.println(item.toString()));
        }
    }

    public ProxyCompiler setCompileOptions(List<String> options) {
        Objects.requireNonNull(options, "options can not be null");
        this.options = options;
        return this;
    }

    public ProxyCompiler addCompileOption(String option) {
        Objects.requireNonNull(option, "option can not be null");
        this.options.add(option);
        return this;
    }

    public static class MyJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        public Map<String, MyJavaFileObject> fileObjects = new HashMap<String, MyJavaFileObject>();

        public MyJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedClassName, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            MyJavaFileObject javaFileObject = new MyJavaFileObject(qualifiedClassName, kind);
            this.fileObjects.put(qualifiedClassName, javaFileObject);
            return javaFileObject;
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            JavaFileObject javaFileObject = this.fileObjects.get(className);
            if (javaFileObject == null) {
                javaFileObject = super.getJavaFileForInput(location, className, kind);
            }
            return javaFileObject;
        }
    }

    public static class MyJavaFileObject
    extends SimpleJavaFileObject {
        private String source;
        private ByteArrayOutputStream outPutStream;

        public MyJavaFileObject(String name, String source) {
            super(URI.create("String:///" + name + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        public MyJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("String:///" + name + kind.extension), kind);
            this.source = null;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            if (this.source == null) {
                throw new IllegalStateException("source field can not be null");
            }
            return this.source;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            this.outPutStream = new ByteArrayOutputStream();
            return this.outPutStream;
        }

        public byte[] getByteCode() {
            return this.outPutStream.toByteArray();
        }
    }
}

