/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.JPagerIndicatorView;
import com.jey_dev.lib.view.R;
import java.util.ArrayList;
import java.util.List;

public class JViewPager
extends RelativeLayout {
    private int dotScaleType = 0;
    private int dotColor = -16777216;
    private int dotCount = 1;
    private boolean isStack = false;
    private boolean isTop = false;
    private boolean isUncheckWhite = false;
    private Context ctx = null;
    private JPagerIndicatorView pagerIndicatorView = null;
    private ViewPager viewPager = null;
    private JViewPagerAdapter viewPagerAdapter = null;
    private View root = null;
    private final ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (null != JViewPager.this.pagerIndicatorView) {
                if ((double)positionOffset > 0.5) {
                    JViewPager.this.pagerIndicatorView.setSelectPosition(position + 1);
                } else {
                    JViewPager.this.pagerIndicatorView.setSelectPosition(position);
                }
            }
        }

        public void onPageSelected(int position) {
            if (null != JViewPager.this.pagerIndicatorView) {
                // empty if block
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public JViewPager(Context context) {
        super(context);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    public JViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    public JViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    @TargetApi(value=21)
    public JViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.getAttrs(attrs, defStyleAttr, defStyleRes);
        this.ctx = context;
        this.initView();
    }

    public void initView() {
        String infService = "layout_inflater";
        LayoutInflater li = (LayoutInflater)this.getContext().getSystemService(infService);
        this.root = li.inflate(R.layout.view_jviewpager, (ViewGroup)this, false);
        this.addView(this.root);
        this.pagerIndicatorView = (JPagerIndicatorView)this.root.findViewById(R.id.jviewpager_indicator);
        this.viewPager = (ViewPager)this.root.findViewById(R.id.jviewpager_viewpager);
        this.pagerIndicatorView.setAttrs(this.dotScaleType, this.dotColor, this.dotCount, this.isStack, this.isUncheckWhite);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(14);
        if (this.isTop) {
            params.addRule(10);
        } else {
            params.addRule(12);
        }
        int margin = JImageUtils.dpToPx(this.ctx, 10);
        params.setMargins(margin, margin, margin, margin);
        this.pagerIndicatorView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.viewPager.addOnPageChangeListener(this.onPageChangeListener);
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JViewPager);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JViewPager, defStyle, 0);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JViewPager, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.isStack = typedArray.getBoolean(R.styleable.JViewPager_isStack, false);
        this.dotScaleType = typedArray.getInt(R.styleable.JViewPager_dotScaleType, 0);
        this.dotCount = typedArray.getInt(R.styleable.JViewPager_dotCount, 1);
        this.dotColor = typedArray.getInt(R.styleable.JViewPager_dotColor, -16777216);
        this.isTop = typedArray.getInt(R.styleable.JViewPager_indicatorPosition, 0) == 0;
        this.isUncheckWhite = typedArray.getBoolean(R.styleable.JViewPager_unCheckWhite, false);
        typedArray.recycle();
    }

    public ViewPager getViewPager() {
        return this.viewPager;
    }

    public void setAdapter(JViewPagerAdapter Adapter) {
        this.viewPager.setAdapter((PagerAdapter)Adapter);
        this.viewPagerAdapter = Adapter;
        this.pagerIndicatorView.setDotCount(Adapter.getCount());
    }

    public void addViewInViewPager(View child, int index, ViewGroup.LayoutParams params) {
        this.viewPager.addView(child, index, params);
    }

    public void addOnpageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPager.addOnPageChangeListener(listener);
    }

    public PagerAdapter getAdapter() {
        return this.viewPager.getAdapter();
    }

    public JViewPagerAdapter getViewPagerAdapter() {
        return this.viewPagerAdapter;
    }

    public int getCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    public void setCurrentItem(int position) {
        this.viewPager.setCurrentItem(position);
    }

    public JPagerIndicatorView getPagerIndicator() {
        return this.pagerIndicatorView;
    }

    public static interface OnChildViewClickListener {
        public void onChildClick(View var1, int var2);
    }

    public static class JViewPagerAdapter
    extends PagerAdapter {
        private final List<View> viewList = new ArrayList<View>();
        private OnChildViewClickListener listener = new OnChildViewClickListener(){

            @Override
            public void onChildClick(View v, int position) {
            }
        };

        public void setOnChildViewClickListener(OnChildViewClickListener listener) {
            this.listener = listener;
        }

        public View getItem(int position) {
            return this.viewList.get(position);
        }

        public int getCount() {
            return this.viewList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public void addView(View view) {
            this.viewList.add(view);
        }

        public Object instantiateItem(View pager, final int position) {
            View v = this.viewList.get(position);
            v.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    JViewPagerAdapter.this.listener.onChildClick(v, position);
                }
            });
            ((ViewPager)pager).addView(v, 0);
            return v;
        }

        public void destroyItem(View pager, int position, Object view) {
            ((ViewPager)pager).removeView((View)view);
        }
    }
}

