/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.R;

public class JIconButton
extends LinearLayout {
    private Context ctx = null;
    private View root = null;
    private ImageView iconView = null;
    private View gabView = null;
    private TextView textView = null;
    private int backgroundColor = R.color.colorPrimaryDark;

    public JIconButton(Context context) {
        super(context);
        this.ctx = context;
        this.setViewIds();
        this.initView();
    }

    public JIconButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ctx = context;
        this.setViewIds();
        this.getAttrs(attrs);
        this.initView();
    }

    @RequiresApi(api=11)
    public JIconButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ctx = context;
        this.setViewIds();
        this.getAttrs(attrs, defStyleAttr);
        this.initView();
    }

    @TargetApi(value=21)
    public JIconButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.ctx = context;
        this.setViewIds();
        this.getAttrs(attrs, defStyleAttr, defStyleRes);
        this.initView();
    }

    private void setViewIds() {
        LayoutInflater.from((Context)this.ctx).inflate(R.layout.view_icon_button, (ViewGroup)this);
        this.root = this.findViewById(R.id.view_icon_button_root);
        this.iconView = (ImageView)this.findViewById(R.id.view_icon_button_icon);
        this.gabView = this.findViewById(R.id.view_icon_button_gab);
        this.textView = (TextView)this.findViewById(R.id.view_icon_button_text);
    }

    private void initView() {
    }

    public void setText(CharSequence cs) {
        this.textView.setText(cs);
    }

    public void setText(String str) {
        this.textView.setText((CharSequence)str);
    }

    public void setText(int strResId) {
        this.textView.setText(strResId);
    }

    public void setTextColor(int color2) {
        this.textView.setTextColor(color2);
    }

    public void setTextColor(ColorStateList color2) {
        this.textView.setTextColor(color2);
    }

    public void setTextSize(float size) {
        this.textView.setTextSize(size);
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setBackground(this.getBackgroundDrawable());
    }

    private Drawable getBackgroundDrawable() {
        Resources res = this.ctx.getResources();
        Drawable layer1 = res.getDrawable(R.drawable.bg_jicon_button_shadow);
        Drawable layer2 = this.getButtonBackground();
        LayerDrawable result = new LayerDrawable(new Drawable[]{layer1, layer2});
        int padding = JImageUtils.dpToPx(this.ctx, 2);
        result.setLayerInset(1, padding, padding, padding, padding);
        return result;
    }

    private Drawable getButtonBackground() {
        int btnColor = this.backgroundColor;
        GradientDrawable g = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{btnColor, btnColor, btnColor});
        g.setShape(0);
        g.setCornerRadius((float)JImageUtils.dpToPx(this.ctx, 10));
        return g;
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JIconButton);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JIconButton, defStyle, 0);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JIconButton, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray a) {
        String text = a.getString(R.styleable.JIconButton_text);
        this.setText(text);
        int textSize = a.getDimensionPixelSize(R.styleable.JIconButton_labelTextSize, 30);
        this.textView.setTextSize(0, (float)textSize);
        int textColor = a.getColor(R.styleable.JIconButton_textColor, -16777216);
        this.setTextColor(textColor);
        int backgroundColor = a.getColor(R.styleable.JIconButton_backgroundColor, this.getResources().getColor(R.color.colorPrimaryDark));
        this.setBackgroundColor(backgroundColor);
        this.iconView.setImageResource(a.getResourceId(R.styleable.JIconButton_iconSrc, this.ctx.getApplicationInfo().icon));
        this.gabView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(a.getDimensionPixelSize(R.styleable.JIconButton_gabSize, JImageUtils.dpToPx(this.ctx, 10)), a.getDimensionPixelSize(R.styleable.JIconButton_gabSize, JImageUtils.dpToPx(this.ctx, 1))));
        this.iconView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(a.getDimensionPixelSize(R.styleable.JIconButton_iconWidth, JImageUtils.dpToPx(this.ctx, 48)), a.getDimensionPixelSize(R.styleable.JIconButton_iconHeight, JImageUtils.dpToPx(this.ctx, 48))));
        int iconPadding = a.getDimensionPixelSize(R.styleable.JIconButton_iconPadding, JImageUtils.dpToPx(this.ctx, 5));
        this.iconView.setPadding(iconPadding, iconPadding, iconPadding, iconPadding);
        a.recycle();
    }
}

