/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.jey_dev.lib.view.R;

public class JToggleButton
extends AppCompatImageView {
    public static final int STYLE_BAR = 0;
    public static final int STYLE_BOX = 1;
    private boolean isChecked = false;
    private int style = 0;

    public JToggleButton(Context context) {
        super(context);
    }

    public JToggleButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.initView();
    }

    public JToggleButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.setClickable(true);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1) {
                    JToggleButton.this.isChecked = !JToggleButton.this.isChecked;
                    JToggleButton.this.onClicked();
                }
                return false;
            }
        });
        this.onClicked();
    }

    private void onClicked() {
        if (this.style == 0) {
            if (this.isChecked) {
                this.setImageResource(R.drawable.bg_jtoggle_on);
            } else {
                this.setImageResource(R.drawable.bg_jtoggle_off);
            }
        } else if (this.style == 1) {
            if (this.isChecked) {
                this.setImageResource(R.drawable.bg_jtoggle_box_on);
            } else {
                this.setImageResource(R.drawable.bg_jtoggle_box_off);
            }
        }
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        this.onClicked();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean getChecked() {
        return this.isChecked;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isChecked) {
            if (this.style == 0) {
                if (enabled) {
                    this.setImageResource(R.drawable.bg_jtoggle_on);
                } else {
                    this.setImageResource(R.drawable.bg_jtoggle_on_disable);
                }
            } else if (this.style == 1) {
                if (enabled) {
                    this.setImageResource(R.drawable.bg_jtoggle_box_on);
                } else {
                    this.setImageResource(R.drawable.bg_jtoggle_box_on_disable);
                }
            }
        }
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JToggleButton);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        this.getAttrs(attrs, defStyle, 0);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JToggleButton, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.isChecked = typedArray.getBoolean(R.styleable.JToggleButton_checked, true);
        this.style = typedArray.getInt(R.styleable.JToggleButton_style, 0);
        typedArray.recycle();
    }
}

