/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.jey_dev.lib.view.JFloatingActionButton;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.R;

public class JeYSnsView
extends LinearLayout {
    public static final int SCALE_NORMAL = 0;
    public static final int SCALE_MINI = 1;
    public static final int SCALE_BIG = 2;
    public static final int SCALE_CUSTOM = 3;
    private int scaleType = 0;
    private int customSize = 0;
    private int customMargin = 8;
    private int imgPadding = 10;
    private View root = null;
    private JFloatingActionButton kakaoView = null;
    private JFloatingActionButton facebookView = null;
    private JFloatingActionButton webView = null;
    private JFloatingActionButton marketView = null;

    public JeYSnsView(Context context) {
        super(context);
        this.initView();
    }

    public JeYSnsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.initView();
    }

    @TargetApi(value=11)
    public JeYSnsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.initView();
    }

    @TargetApi(value=21)
    public JeYSnsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.getAttrs(attrs, defStyleAttr, defStyleRes);
        this.initView();
    }

    private void initView() {
        String infService = "layout_inflater";
        LayoutInflater li = (LayoutInflater)this.getContext().getSystemService(infService);
        this.root = li.inflate(R.layout.view_sns, (ViewGroup)this, false);
        this.addView(this.root);
        this.kakaoView = (JFloatingActionButton)this.findViewById(R.id.sns_kakao);
        this.facebookView = (JFloatingActionButton)this.findViewById(R.id.sns_facebook);
        this.webView = (JFloatingActionButton)this.findViewById(R.id.sns_web);
        this.marketView = (JFloatingActionButton)this.findViewById(R.id.sns_market);
        this.webView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.intent.action.VIEW");
                Uri u = Uri.parse((String)"http://www.jey-dev.com");
                intent.setData(u);
                JeYSnsView.this.startActivity(intent);
            }
        });
        this.kakaoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"http://story.kakao.com/ch/jeydevcompany/app"));
                JeYSnsView.this.startActivity(intent);
            }
        });
        this.facebookView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String facebookID = "1521326674797347";
                try {
                    Uri uri = Uri.parse((String)("fb://page/" + facebookID));
                    JeYSnsView.this.startActivity(new Intent("android.intent.action.VIEW", uri));
                }
                catch (Exception e) {
                    Intent i = new Intent("android.intent.action.VIEW");
                    Uri u = Uri.parse((String)("http://www.facebook.com/" + facebookID));
                    i.setData(u);
                    JeYSnsView.this.startActivity(i);
                }
            }
        });
        this.marketView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                JeYSnsView.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"http://jey-dev.com/jey/store.php")));
            }
        });
        this.setButtonSize();
    }

    public void setScaleType(int scaleType) {
        this.scaleType = scaleType;
        this.setButtonSize();
    }

    private void setButtonSize() {
        int margins = JImageUtils.dpToPx(this.getContext(), 10);
        this.facebookView.setScaleType(this.scaleType);
        this.kakaoView.setScaleType(this.scaleType);
        this.webView.setScaleType(this.scaleType);
        this.marketView.setScaleType(this.scaleType);
        if (this.scaleType == 3) {
            this.facebookView.setCustomSize(this.customSize);
            this.kakaoView.setCustomSize(this.customSize);
            this.webView.setCustomSize(this.customSize);
            this.marketView.setCustomSize(this.customSize);
        }
        this.facebookView.setImgPadding(this.imgPadding);
        this.kakaoView.setImgPadding(this.imgPadding);
        this.webView.setImgPadding(this.imgPadding);
        this.marketView.setImgPadding(this.imgPadding);
        LinearLayout.LayoutParams facebookParams = (LinearLayout.LayoutParams)this.facebookView.getLayoutParams();
        LinearLayout.LayoutParams kakaoParams = (LinearLayout.LayoutParams)this.kakaoView.getLayoutParams();
        LinearLayout.LayoutParams webParams = (LinearLayout.LayoutParams)this.webView.getLayoutParams();
        LinearLayout.LayoutParams marketParams = (LinearLayout.LayoutParams)this.marketView.getLayoutParams();
        facebookParams.setMargins(this.customMargin, this.customMargin, this.customMargin, this.customMargin);
        kakaoParams.setMargins(this.customMargin, this.customMargin, this.customMargin, this.customMargin);
        webParams.setMargins(this.customMargin, this.customMargin, this.customMargin, this.customMargin);
        marketParams.setMargins(this.customMargin, this.customMargin, this.customMargin, this.customMargin);
        this.facebookView.setLayoutParams((ViewGroup.LayoutParams)facebookParams);
        this.kakaoView.setLayoutParams((ViewGroup.LayoutParams)kakaoParams);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)webParams);
        this.marketView.setLayoutParams((ViewGroup.LayoutParams)marketParams);
    }

    private void startActivity(Intent intent) {
        this.getContext().startActivity(intent);
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JeYSnsView);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JeYSnsView, defStyle, 0);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JeYSnsView, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.scaleType = typedArray.getInt(R.styleable.JeYSnsView_scaleType, 0);
        this.customSize = typedArray.getDimensionPixelSize(R.styleable.JeYSnsView_customSize, JImageUtils.dpToPx(this.getContext(), 64));
        this.customMargin = typedArray.getDimensionPixelSize(R.styleable.JeYSnsView_customMargin, JImageUtils.dpToPx(this.getContext(), 8));
        this.imgPadding = typedArray.getDimensionPixelSize(R.styleable.JeYSnsView_imgPadding, JImageUtils.dpToPx(this.getContext(), 10));
        typedArray.recycle();
    }
}

