/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.JPagerIndicatorView;
import com.jey_dev.lib.view.R;
import java.util.ArrayList;
import java.util.List;

public class JFragmentPager
extends RelativeLayout {
    private int dotScaleType = 0;
    private int dotColor = -16777216;
    private int dotCount = 2;
    private boolean isStack = false;
    private boolean isTop = false;
    private boolean isUncheckWhite = false;
    private Context ctx = null;
    private JPagerIndicatorView pagerIndicatorView = null;
    private ViewPager viewPager = null;
    private JFragmentPagerAdapter viewPagerAdapter = null;
    private View root = null;
    private final ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (null != JFragmentPager.this.pagerIndicatorView) {
                if ((double)positionOffset > 0.5) {
                    JFragmentPager.this.pagerIndicatorView.setSelectPosition(position + 1);
                } else {
                    JFragmentPager.this.pagerIndicatorView.setSelectPosition(position);
                }
            }
        }

        public void onPageSelected(int position) {
            if (null != JFragmentPager.this.pagerIndicatorView) {
                // empty if block
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public JFragmentPager(Context context) {
        super(context);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    public JFragmentPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    public JFragmentPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    @TargetApi(value=21)
    public JFragmentPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.getAttrs(attrs, defStyleAttr, defStyleRes);
        this.ctx = context;
        if (!this.isInEditMode()) {
            this.initView();
        }
    }

    public void initView() {
        String infService = "layout_inflater";
        LayoutInflater li = (LayoutInflater)this.getContext().getSystemService(infService);
        this.root = li.inflate(R.layout.view_jviewpager, (ViewGroup)this, false);
        this.addView(this.root);
        this.pagerIndicatorView = (JPagerIndicatorView)this.root.findViewById(R.id.jviewpager_indicator);
        this.viewPager = (ViewPager)this.root.findViewById(R.id.jviewpager_viewpager);
        this.pagerIndicatorView.setAttrs(this.dotScaleType, this.dotColor, this.dotCount, this.isStack, this.isUncheckWhite);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(14);
        if (this.isTop) {
            params.addRule(10);
        } else {
            params.addRule(12);
        }
        int margin = JImageUtils.dpToPx(this.ctx, 10);
        params.setMargins(margin, margin, margin, margin);
        this.pagerIndicatorView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.viewPager.addOnPageChangeListener(this.onPageChangeListener);
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFragmentPager);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFragmentPager, defStyle, 0);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFragmentPager, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.isStack = typedArray.getBoolean(R.styleable.JFragmentPager_isStack, false);
        this.dotScaleType = typedArray.getInt(R.styleable.JFragmentPager_dotScaleType, 0);
        this.dotCount = typedArray.getInt(R.styleable.JFragmentPager_dotCount, 2);
        this.dotColor = typedArray.getInt(R.styleable.JFragmentPager_dotColor, -16777216);
        this.isTop = typedArray.getInt(R.styleable.JFragmentPager_indicatorPosition, 0) == 0;
        this.isUncheckWhite = typedArray.getBoolean(R.styleable.JFragmentPager_unCheckWhite, false);
        typedArray.recycle();
    }

    public ViewPager getViewPager() {
        return this.viewPager;
    }

    public void setAdapter(JFragmentPagerAdapter Adapter) {
        this.viewPager.setAdapter((PagerAdapter)Adapter);
        this.viewPagerAdapter = Adapter;
        this.pagerIndicatorView.setDotCount(Adapter.getCount());
    }

    public void addViewInViewPager(View child, int index, ViewGroup.LayoutParams params) {
        this.viewPager.addView(child, index, params);
    }

    public void addOnpageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPager.addOnPageChangeListener(listener);
    }

    public PagerAdapter getAdapter() {
        return this.viewPager.getAdapter();
    }

    public JFragmentPagerAdapter getViewPagerAdapter() {
        return this.viewPagerAdapter;
    }

    public int getCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    public JPagerIndicatorView getPagerIndicator() {
        return this.pagerIndicatorView;
    }

    public static class JFragmentPagerAdapter
    extends FragmentPagerAdapter {
        private final List<Fragment> mFragmentList = new ArrayList<Fragment>();
        private final List<String> mFragmentTitleList = new ArrayList<String>();

        public JFragmentPagerAdapter(FragmentManager manager) {
            super(manager);
        }

        public Fragment getItem(int position) {
            return this.mFragmentList.get(position);
        }

        public int getCount() {
            return this.mFragmentList.size();
        }

        public void addFragment(Fragment fragment, String title) {
            this.mFragmentList.add(fragment);
            this.mFragmentTitleList.add(title);
        }

        public CharSequence getPageTitle(int position) {
            return this.mFragmentTitleList.get(position);
        }
    }
}

