/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.R;

public class JFloatingActionButton
extends AppCompatImageView {
    public static final int SCALE_NORMAL = 0;
    public static final int SCALE_MINI = 1;
    public static final int SCALE_BIG = 2;
    public static final int SCALE_CUSTOM = 3;
    private int customSize = 0;
    private int scaleType = 0;
    private int tintColor = Color.parseColor((String)"#FF006934");
    private int imgPadding = 10;
    private LayerDrawable layerDrawable = null;
    private Context ctx = null;

    public JFloatingActionButton(Context context) {
        super(context);
        this.ctx = context;
        this.initView();
    }

    public JFloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ctx = context;
        this.getAttrs(attrs);
        this.initView();
    }

    public JFloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ctx = context;
        this.getAttrs(attrs, defStyleAttr);
        this.initView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mini = JImageUtils.dpToPx(this.getContext(), 50);
        int normal = JImageUtils.dpToPx(this.getContext(), 64);
        int big = JImageUtils.dpToPx(this.getContext(), 100);
        int size = normal;
        switch (this.scaleType) {
            case 0: {
                size = normal;
                break;
            }
            case 1: {
                size = mini;
                break;
            }
            case 2: {
                size = big;
                break;
            }
            case 3: {
                size = this.customSize;
            }
        }
        this.setMeasuredDimension(size, size);
    }

    private void initView() {
        this.setClickable(true);
        this.layerDrawable = this.getLayerDrawable();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)this.layerDrawable);
        } else {
            this.setBackgroundDrawable((Drawable)this.layerDrawable);
        }
        this.setPadding(this.imgPadding, this.imgPadding, this.imgPadding, this.imgPadding);
    }

    private LayerDrawable getLayerDrawable() {
        Resources res = this.ctx.getResources();
        Drawable layer1 = res.getDrawable(R.drawable.bg_shadow);
        ShapeDrawable layer2 = this.getButtonBackground(this.tintColor);
        LayerDrawable result = new LayerDrawable(new Drawable[]{layer1, layer2});
        int padding = JImageUtils.dpToPx(this.ctx, 5);
        result.setLayerInset(1, padding, padding, padding, padding);
        return result;
    }

    private ShapeDrawable getButtonBackground(int tintColor) {
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new OvalShape());
        drawable2.getPaint().setColor(tintColor);
        return drawable2;
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFloatingActionButton);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFloatingActionButton, defStyle, 0);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFloatingActionButton, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.scaleType = typedArray.getInt(R.styleable.JFloatingActionButton_scaleType, 0);
        this.tintColor = typedArray.getColor(R.styleable.JFloatingActionButton_tintColor, Color.parseColor((String)"#FF006934"));
        this.imgPadding = typedArray.getDimensionPixelSize(R.styleable.JFloatingActionButton_imgPadding, JImageUtils.dpToPx(this.ctx, 10));
        this.customSize = typedArray.getDimensionPixelSize(R.styleable.JFloatingActionButton_customSize, JImageUtils.dpToPx(this.ctx, 64));
        typedArray.recycle();
    }

    public JFloatingActionButton setScaleType(int scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    public JFloatingActionButton setTintColor(int tintColor) {
        this.tintColor = tintColor;
        ((ShapeDrawable)this.layerDrawable.getDrawable(1)).getPaint().setColor(tintColor);
        return this;
    }
}

