/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.R;
import java.util.ArrayList;

public class JPagerIndicatorView
extends LinearLayout {
    public static final int SCALE_NORMAL = 0;
    public static final int SCALE_SMALL = 1;
    public static final int SCALE_BIG = 2;
    private int scaleType = 0;
    private int dotColor = -16777216;
    private int dotCount = 1;
    private boolean isStack = false;
    private Context ctx = null;
    private ArrayList<View> views = new ArrayList();
    private int nowPosition = 0;
    private boolean isUncheckWhite = false;

    public JPagerIndicatorView(Context context) {
        super(context);
        this.ctx = context;
        this.initView();
    }

    public JPagerIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.ctx = context;
        this.initView();
    }

    @RequiresApi(api=11)
    public JPagerIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.ctx = context;
        this.initView();
    }

    @TargetApi(value=21)
    public JPagerIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.getAttrs(attrs, defStyleAttr, defStyleRes);
        this.ctx = context;
        this.initView();
    }

    private void initView() {
        this.setOrientation(0);
        int normalSize = JImageUtils.dpToPx(this.ctx, 10);
        int smallSize = JImageUtils.dpToPx(this.ctx, 5);
        int bigSize = JImageUtils.dpToPx(this.ctx, 20);
        int size = normalSize;
        if (this.scaleType == 0) {
            size = normalSize;
        } else if (this.scaleType == 1) {
            size = smallSize;
        } else if (this.scaleType == 2) {
            size = bigSize;
        }
        for (int i = 0; i < this.dotCount; ++i) {
            View view = null;
            view = i == 0 ? this.getView(this.getCheckedDrawable(), size) : this.getView(this.getUnCheckedDrawable(), size);
            this.views.add(view);
            this.addView(view);
        }
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JPagerIndicatorView);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JPagerIndicatorView, defStyle, 0);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JPagerIndicatorView, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.isStack = typedArray.getBoolean(R.styleable.JPagerIndicatorView_isStack, false);
        this.scaleType = typedArray.getInt(R.styleable.JPagerIndicatorView_dotScaleType, 0);
        this.dotCount = typedArray.getInt(R.styleable.JPagerIndicatorView_dotCount, 1);
        this.dotColor = typedArray.getInt(R.styleable.JPagerIndicatorView_dotColor, -16777216);
        this.isUncheckWhite = typedArray.getBoolean(R.styleable.JPagerIndicatorView_unCheckWhite, false);
        typedArray.recycle();
    }

    private Drawable getCheckedDrawable() {
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new OvalShape());
        drawable2.getPaint().setColor(this.dotColor);
        return drawable2;
    }

    private Drawable getUnCheckedDrawable() {
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new OvalShape());
        if (this.isUncheckWhite) {
            drawable2.getPaint().setColor(-1);
        } else {
            drawable2.getPaint().setColor(this.dotColor);
            drawable2.getPaint().setAlpha(80);
        }
        return drawable2;
    }

    private View getView(Drawable drawable2, int size) {
        int padding = size / 2;
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(size, size);
        params.setMargins(padding, padding, padding, padding);
        View view = new View(this.ctx);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        if (JImageUtils.isOverAPI16()) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
        return view;
    }

    public void setSelectPosition(int position) {
        this.nowPosition = position;
        this.refreshDots();
    }

    public void nextPosition() {
        if (this.nowPosition < this.dotCount - 1) {
            ++this.nowPosition;
            this.refreshDots();
        }
    }

    public void prePosition() {
        if (this.nowPosition > 0) {
            --this.nowPosition;
            this.refreshDots();
        }
    }

    public int getNowPosition() {
        return this.nowPosition;
    }

    public int getSelectPosition() {
        return this.nowPosition;
    }

    public void setScaleType(int scaleType) {
        this.scaleType = scaleType;
        this.removeAllViews();
        this.initView();
    }

    public void setDotColor(int dotColor) {
        this.dotColor = dotColor;
        this.removeAllViews();
        this.initView();
    }

    public void setDotCount(int dotCount) {
        this.dotCount = dotCount;
        this.removeAllViews();
        this.initView();
    }

    public void setStack(boolean isStack) {
        this.isStack = isStack;
        this.removeAllViews();
        this.initView();
    }

    public void setAttrs(int scaleType, int dotColor, int dotCount, boolean isStack, boolean isUncheckWhite) {
        this.removeAllViews();
        this.scaleType = scaleType;
        this.dotColor = dotColor;
        this.dotCount = dotCount;
        this.isStack = isStack;
        this.isUncheckWhite = isUncheckWhite;
        this.initView();
    }

    public void removeAllViews() {
        super.removeAllViews();
        this.views.clear();
    }

    private void refreshDots() {
        for (int i = 0; i < this.dotCount; ++i) {
            if (i <= this.nowPosition) {
                if (this.isStack) {
                    if (JImageUtils.isOverAPI16()) {
                        this.views.get(i).setBackground(this.getCheckedDrawable());
                        continue;
                    }
                    this.views.get(i).setBackgroundDrawable(this.getCheckedDrawable());
                    continue;
                }
                if (i == this.nowPosition) {
                    if (JImageUtils.isOverAPI16()) {
                        this.views.get(i).setBackground(this.getCheckedDrawable());
                        continue;
                    }
                    this.views.get(i).setBackgroundDrawable(this.getCheckedDrawable());
                    continue;
                }
            }
            if (JImageUtils.isOverAPI16()) {
                this.views.get(i).setBackground(this.getUnCheckedDrawable());
                continue;
            }
            this.views.get(i).setBackgroundDrawable(this.getUnCheckedDrawable());
        }
    }
}

