/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.R;

public class JClearEditText
extends AppCompatAutoCompleteTextView
implements TextWatcher,
View.OnTouchListener,
View.OnFocusChangeListener {
    private Drawable clearDrawable;
    private Drawable leftDrawable = null;
    private View.OnFocusChangeListener onFocusChangeListener;
    private View.OnTouchListener onTouchListener;
    private View.OnClickListener onClearListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    public JClearEditText(Context context) {
        super(context);
        this.init();
    }

    public JClearEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public JClearEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.onFocusChangeListener = onFocusChangeListener;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.onTouchListener = onTouchListener;
    }

    private void init() {
        Drawable tempDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_clear_white_24dp);
        this.clearDrawable = DrawableCompat.wrap((Drawable)tempDrawable);
        DrawableCompat.setTintList((Drawable)this.clearDrawable, (ColorStateList)this.getHintTextColors());
        int dip24 = JImageUtils.dpToPx(this.getContext(), 24);
        this.clearDrawable.setBounds(0, 0, dip24, dip24);
        this.setClearIconVisible(false);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(this);
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.onFocusChangeListener != null) {
            this.onFocusChangeListener.onFocusChange(view, hasFocus);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int x = (int)motionEvent.getX();
        if (this.clearDrawable.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.clearDrawable.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                this.setError(null);
                this.setText(null);
                this.onClearListener.onClick(view);
            }
            return true;
        }
        if (this.onTouchListener != null) {
            return this.onTouchListener.onTouch(view, motionEvent);
        }
        return false;
    }

    public final void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isFocused()) {
            this.setClearIconVisible(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    private void setClearIconVisible(boolean visible) {
        this.clearDrawable.setVisible(visible, false);
        this.setCompoundDrawables(null != this.leftDrawable ? (this.leftDrawable.isVisible() ? this.leftDrawable : null) : null, null, visible ? this.clearDrawable : null, null);
    }

    public void setLeftIconVisible(boolean visible) {
        if (null != this.leftDrawable) {
            this.leftDrawable.setVisible(visible, false);
        }
        this.setCompoundDrawables(null != this.leftDrawable ? (this.leftDrawable.isVisible() ? this.leftDrawable : null) : null, null, this.clearDrawable.isVisible() ? this.clearDrawable : null, null);
    }

    public void setLeftDrawable(int resId) {
        this.setLeftDrawable(resId, null);
    }

    public void setLeftDrawable(int resId, ColorStateList colorStateList) {
        Drawable tempDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
        this.leftDrawable = DrawableCompat.wrap((Drawable)tempDrawable);
        if (null != colorStateList) {
            DrawableCompat.setTintList((Drawable)this.leftDrawable, (ColorStateList)colorStateList);
        }
        int dip24 = JImageUtils.dpToPx(this.getContext(), 24);
        this.leftDrawable.setBounds(0, 0, dip24, dip24);
        this.setLeftIconVisible(true);
    }

    public Drawable getLeftDrawable() {
        return this.leftDrawable;
    }

    public void setOnClearClickListener(View.OnClickListener listener) {
        this.onClearListener = listener;
    }
}

