/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.jey_dev.lib.view.R;

public class JToggleButton
extends AppCompatImageView {
    private boolean isChecked = false;

    public JToggleButton(Context context) {
        super(context);
    }

    public JToggleButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.initView();
    }

    public JToggleButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.setClickable(true);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1) {
                    JToggleButton.this.isChecked = !JToggleButton.this.isChecked;
                    JToggleButton.this.onClicked();
                }
                return false;
            }
        });
        this.onClicked();
    }

    public void onClick(View view) {
    }

    private void onClicked() {
        if (this.isChecked) {
            this.setImageResource(R.drawable.bg_jtoggle_on);
        } else {
            this.setImageResource(R.drawable.bg_jtoggle_off);
        }
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        this.onClicked();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean getChecked() {
        return this.isChecked;
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JToggleButton);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        this.getAttrs(attrs, defStyle, 0);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JToggleButton, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.isChecked = typedArray.getBoolean(R.styleable.JToggleButton_checked, true);
        typedArray.recycle();
    }
}

