/*
 * Decompiled with CFR 0.152.
 */
package com.jey_dev.lib.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jey_dev.lib.view.JImageUtils;
import com.jey_dev.lib.view.R;

public class JClearSearchText
extends AppCompatAutoCompleteTextView
implements TextWatcher,
View.OnTouchListener,
View.OnFocusChangeListener {
    private Drawable clearDrawable;
    private Drawable searchDrawable;
    private View.OnFocusChangeListener onFocusChangeListener;
    private View.OnTouchListener onTouchListener;
    private View.OnClickListener onClearListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };
    private boolean isSearchIconBack = true;
    private View.OnClickListener onSearchListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    public JClearSearchText(Context context) {
        super(context);
        this.init();
    }

    public JClearSearchText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(attrs);
        this.init();
    }

    public JClearSearchText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttrs(attrs, defStyleAttr);
        this.init();
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.onFocusChangeListener = onFocusChangeListener;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.onTouchListener = onTouchListener;
    }

    private void init() {
        this.setInputType(1);
        this.setImeOptions(3);
        Drawable tempDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_clear_white_24dp);
        Drawable temp0Drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_search_black_24dip);
        this.clearDrawable = DrawableCompat.wrap((Drawable)tempDrawable);
        DrawableCompat.setTintList((Drawable)this.clearDrawable, (ColorStateList)this.getHintTextColors());
        this.searchDrawable = DrawableCompat.wrap((Drawable)temp0Drawable);
        DrawableCompat.setTintList((Drawable)this.searchDrawable, (ColorStateList)this.getTextColors());
        int dip24 = JImageUtils.dpToPx(this.getContext(), 20);
        this.clearDrawable.setBounds(0, 0, dip24, dip24);
        this.searchDrawable.setBounds(0, 0, dip24, dip24);
        this.setClearIconVisible(false);
        this.setSearchIconVisible(true);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(this);
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.onFocusChangeListener != null) {
            this.onFocusChangeListener.onFocusChange(view, hasFocus);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int x = (int)motionEvent.getX();
        if (this.clearDrawable.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.clearDrawable.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                this.setError(null);
                this.setText(null);
                this.onClearListener.onClick(view);
            }
            return true;
        }
        if (this.searchDrawable.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.searchDrawable.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                this.onSearchListener.onClick(view);
            }
            return true;
        }
        if (this.onTouchListener != null) {
            return this.onTouchListener.onTouch(view, motionEvent);
        }
        return false;
    }

    public final void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isFocused()) {
            this.setClearIconVisible(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    private void setClearIconVisible(boolean visible) {
        this.clearDrawable.setVisible(visible, false);
        this.setCompoundDrawables(this.isSearchIconBack ? null : this.searchDrawable, null, (Drawable)(visible ? this.clearDrawable : (this.isSearchIconBack ? this.searchDrawable : null)), null);
    }

    private void setSearchIconVisible(boolean visible) {
        this.searchDrawable.setVisible(visible, false);
        this.setCompoundDrawables(this.isSearchIconBack ? null : this.searchDrawable, null, visible ? (this.isSearchIconBack ? this.searchDrawable : null) : null, null);
    }

    private void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFloatingActionButton);
        this.setTypeArray(typedArray);
    }

    private void getAttrs(AttributeSet attrs, int defStyle) {
        this.getAttrs(attrs, defStyle, 0);
    }

    private void getAttrs(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.JFloatingActionButton, defStyle, defStyleRes);
        this.setTypeArray(typedArray);
    }

    private void setTypeArray(TypedArray typedArray) {
        this.isSearchIconBack = typedArray.getBoolean(R.styleable.JClearSearchText_searchIconLeft, true);
        typedArray.recycle();
    }

    public void setOnClearClickListener(View.OnClickListener listener) {
        this.onClearListener = listener;
    }

    public void setOnSearchListener(View.OnClickListener listener) {
        this.onSearchListener = listener;
    }

    public boolean isSearchIconBack() {
        return this.isSearchIconBack;
    }

    public void setSearchIconBack(boolean isSearchIconBack) {
        this.isSearchIconBack = isSearchIconBack;
    }
}

