/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.mods.stomp;

import java.util.HashMap;
import java.util.Map;
import org.vertx.java.core.json.JsonObject;

class Frame {
    final String command;
    final Map<String, String> headers = new HashMap<String, String>();
    String body;

    Frame(String command) {
        this.command = command.toUpperCase();
    }

    JsonObject toJSON() {
        JsonObject json = new JsonObject();
        if (this.headers.keySet().size() > 0) {
            JsonObject jHeaders = new JsonObject();
            for (Map.Entry<String, String> kv : this.headers.entrySet()) {
                jHeaders.putString(kv.getKey(), kv.getValue());
            }
            json.putObject("headers", jHeaders);
        }
        if (this.body != null) {
            String mapping = this.headers.get("transformation");
            if ("jms-map-json".equals(mapping)) {
                json.putObject("body", new JsonObject(this.body));
            } else {
                json.putString("body", this.body);
            }
        }
        return json;
    }

    void parseHeader(String key, String value) {
        this.headers.put(key, Frame.unescape(value));
    }

    void putHeader(String key, String value) {
        this.headers.put(key, value);
    }

    static String escape(String value) {
        return value.replaceAll("\\\\", "\\\\").replaceAll(":", "\\c").replaceAll("\n", "\\n").replaceAll("\r", "\\r");
    }

    static String unescape(String value) {
        return value.replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n").replaceAll("\\\\c", ":").replaceAll("\\\\\\\\", "\\\\");
    }
}

