/*
 * Decompiled with CFR 0.152.
 */
package com.jeffg.live_text_view;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.daimajia.androidanimations.library.Techniques;
import com.daimajia.androidanimations.library.YoYo;
import com.jeffg.live_text_view.LiveTextViewTTS;
import com.jeffg.live_text_view.R;
import java.util.ArrayList;
import org.jsoup.Jsoup;

public class LiveTextView
extends RelativeLayout {
    private Context context;
    private AttributeSet attrs;
    private int styleAttr;
    private View view;
    TextView previous;
    TextView current;
    TextView next;
    LinearLayout parent;
    int textColor;
    int backgroundColor;
    int smallTextSize;
    int largeTextSize;
    boolean animate;
    boolean paused;
    boolean playing;
    LiveTextViewTTS liveTextViewTTS;
    OnLoadListener onLoadListener;
    OnFinishListener onFinishListener;
    ArrayList<String> text;
    TextToSpeech textToSpeech;
    int currentIndex;

    public LiveTextView(Context context) {
        super(context);
        this.context = context;
        this.initView();
    }

    public LiveTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.attrs = attrs;
        this.initView();
    }

    public LiveTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.attrs = attrs;
        this.styleAttr = defStyleAttr;
        this.initView();
    }

    private void initView() {
        this.view = this;
        LiveTextView.inflate((Context)this.context, (int)R.layout.live_text_view_layout, (ViewGroup)this);
        TypedArray arr = this.context.obtainStyledAttributes(this.attrs, R.styleable.LiveTextView, this.styleAttr, 0);
        this.textColor = arr.getColor(R.styleable.LiveTextView_android_textColor, -16777216);
        this.backgroundColor = arr.getColor(R.styleable.LiveTextView_android_background, -1);
        this.smallTextSize = arr.getInteger(R.styleable.LiveTextView_smallTextSize, 12);
        this.largeTextSize = arr.getInteger(R.styleable.LiveTextView_largeTextSize, 14);
        this.animate = false;
        this.parent = (LinearLayout)this.findViewById(R.id.parent);
        this.next = (TextView)this.findViewById(R.id.nextTV);
        this.previous = (TextView)this.findViewById(R.id.previousTV);
        this.current = (TextView)this.findViewById(R.id.currentTV);
        this.currentIndex = 0;
        this.paused = false;
        this.playing = false;
        this.setTextColor(this.textColor);
        this.setBackgroundColor(this.backgroundColor);
        this.setSmallTextSize(this.smallTextSize);
        this.setLargeTextSize(this.largeTextSize);
        arr.recycle();
    }

    public void setTextColor(int color) {
        this.previous.setTextColor(color);
        this.current.setTextColor(color);
        this.next.setTextColor(color);
    }

    public void setBackgroundColor(int color) {
        this.parent.setBackgroundColor(color);
        this.previous.setBackgroundColor(color);
        this.current.setBackgroundColor(color);
        this.next.setBackgroundColor(color);
    }

    public void setTypeface(Typeface tf) {
        this.previous.setTypeface(tf);
        this.current.setTypeface(tf);
        this.next.setTypeface(tf);
    }

    public void setOnLoadListener(OnLoadListener listener) {
        this.onLoadListener = listener;
    }

    public void setOnFinishListener(OnFinishListener listener) {
        this.onFinishListener = listener;
    }

    public void animate(boolean bool) {
        this.animate = bool;
    }

    public void setLiveTextViewTTS(LiveTextViewTTS tts) {
        this.liveTextViewTTS = tts;
    }

    public void setSmallTextSize(int size) {
        this.previous.setTextSize(2, (float)size);
        this.next.setTextSize(2, (float)size);
    }

    public void setLargeTextSize(int size) {
        this.current.setTextSize(2, (float)size);
    }

    public void setText(String text1) {
        String[] splitText = text1.split("\\.");
        this.text = new ArrayList();
        for (String sentence : splitText) {
            this.text.add(Jsoup.parse((String)sentence).text());
        }
    }

    public void setSentences(ArrayList<String> sentences) {
        this.text = new ArrayList();
        for (String sentence : sentences) {
            this.text.add(Jsoup.parse((String)sentence).text());
        }
    }

    public void setSentences(String[] sentences) {
        this.text = new ArrayList();
        for (String sentence : sentences) {
            this.text.add(Jsoup.parse((String)sentence).text());
        }
    }

    private void setTextViews(Boolean isNext) {
        if (isNext == null) {
            Activity activity = (Activity)this.view.getContext();
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LiveTextView.this.previous.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex - 1));
                    }
                    catch (IndexOutOfBoundsException e) {
                        LiveTextView.this.previous.setText((CharSequence)"");
                    }
                    try {
                        LiveTextView.this.current.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex));
                    }
                    catch (IndexOutOfBoundsException e) {
                        LiveTextView.this.current.setText((CharSequence)"");
                    }
                    try {
                        LiveTextView.this.next.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex + 1));
                    }
                    catch (IndexOutOfBoundsException e) {
                        LiveTextView.this.next.setText((CharSequence)"");
                    }
                }
            });
        } else if (isNext.booleanValue()) {
            Activity activity = (Activity)this.view.getContext();
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    YoYo.with((Techniques)Techniques.FadeOutUp).duration(300L).onEnd(new YoYo.AnimatorCallback(){

                        public void call(Animator animator) {
                            try {
                                LiveTextView.this.previous.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex - 1));
                                YoYo.with((Techniques)Techniques.FadeInUp).duration(300L).playOn((View)LiveTextView.this.previous);
                            }
                            catch (IndexOutOfBoundsException e) {
                                LiveTextView.this.previous.setText((CharSequence)"");
                            }
                        }
                    }).playOn((View)LiveTextView.this.previous);
                    YoYo.with((Techniques)Techniques.FadeOutUp).duration(300L).onEnd(new YoYo.AnimatorCallback(){

                        public void call(Animator animator) {
                            try {
                                LiveTextView.this.current.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex));
                                YoYo.with((Techniques)Techniques.FadeInUp).duration(300L).playOn((View)LiveTextView.this.current);
                            }
                            catch (IndexOutOfBoundsException e) {
                                LiveTextView.this.current.setText((CharSequence)"");
                            }
                        }
                    }).playOn((View)LiveTextView.this.current);
                    YoYo.with((Techniques)Techniques.FadeOutUp).duration(300L).onEnd(new YoYo.AnimatorCallback(){

                        public void call(Animator animator) {
                            try {
                                LiveTextView.this.next.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex + 1));
                                YoYo.with((Techniques)Techniques.FadeInUp).duration(300L).playOn((View)LiveTextView.this.next);
                            }
                            catch (IndexOutOfBoundsException e) {
                                LiveTextView.this.next.setText((CharSequence)"");
                            }
                        }
                    }).playOn((View)LiveTextView.this.next);
                }
            });
        } else {
            Activity activity = (Activity)this.view.getContext();
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    YoYo.with((Techniques)Techniques.FadeOutDown).duration(300L).onEnd(new YoYo.AnimatorCallback(){

                        public void call(Animator animator) {
                            try {
                                LiveTextView.this.previous.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex - 1));
                                YoYo.with((Techniques)Techniques.FadeInDown).duration(300L).playOn((View)LiveTextView.this.previous);
                            }
                            catch (IndexOutOfBoundsException e) {
                                LiveTextView.this.previous.setText((CharSequence)"");
                            }
                        }
                    }).playOn((View)LiveTextView.this.previous);
                    YoYo.with((Techniques)Techniques.FadeOutDown).duration(300L).onEnd(new YoYo.AnimatorCallback(){

                        public void call(Animator animator) {
                            try {
                                LiveTextView.this.current.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex));
                                YoYo.with((Techniques)Techniques.FadeInDown).duration(300L).playOn((View)LiveTextView.this.current);
                            }
                            catch (IndexOutOfBoundsException e) {
                                LiveTextView.this.current.setText((CharSequence)"");
                            }
                        }
                    }).playOn((View)LiveTextView.this.current);
                    YoYo.with((Techniques)Techniques.FadeOutDown).duration(300L).onEnd(new YoYo.AnimatorCallback(){

                        public void call(Animator animator) {
                            try {
                                LiveTextView.this.next.setText((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex + 1));
                                YoYo.with((Techniques)Techniques.FadeInDown).duration(300L).playOn((View)LiveTextView.this.next);
                            }
                            catch (IndexOutOfBoundsException e) {
                                LiveTextView.this.next.setText((CharSequence)"");
                            }
                        }
                    }).playOn((View)LiveTextView.this.next);
                }
            });
        }
    }

    private void previous() {
        this.currentIndex = Math.max(0, this.currentIndex - 1);
        this.start();
        if (this.animate) {
            this.setTextViews(false);
        } else {
            this.setTextViews(null);
        }
    }

    public void pause() {
        if (this.textToSpeech != null) {
            this.paused = true;
            this.playing = false;
            this.textToSpeech.stop();
            this.textToSpeech.shutdown();
        }
    }

    public void stop() {
        if (this.textToSpeech != null) {
            this.textToSpeech.stop();
            this.textToSpeech.shutdown();
            this.playing = false;
        }
    }

    public void reset() {
        if (this.textToSpeech != null) {
            this.textToSpeech.stop();
            this.textToSpeech.shutdown();
            this.currentIndex = 0;
            this.playing = false;
        }
    }

    public void resume() {
        this.start();
    }

    public void fast_forwards() {
        this.pause();
        this.next();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void fast_rewind() {
        this.pause();
        this.previous();
    }

    private void next() {
        this.currentIndex = Math.min(this.currentIndex + 1, this.text.size() - 1);
        if (this.currentIndex >= this.text.size()) {
            this.stop();
        } else {
            this.start();
            if (this.animate) {
                this.setTextViews(true);
            } else {
                this.setTextViews(null);
            }
        }
    }

    public void start() {
        this.textToSpeech = new TextToSpeech(this.context, new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                if (status == 0) {
                    if (LiveTextView.this.onLoadListener != null) {
                        LiveTextView.this.onLoadListener.onLoad(LiveTextView.this);
                    }
                    if (LiveTextView.this.liveTextViewTTS != null) {
                        if (LiveTextView.this.liveTextViewTTS.pitch != null) {
                            LiveTextView.this.textToSpeech.setPitch(LiveTextView.this.liveTextViewTTS.pitch.floatValue());
                        }
                        if (LiveTextView.this.liveTextViewTTS.language != null) {
                            LiveTextView.this.textToSpeech.setLanguage(LiveTextView.this.liveTextViewTTS.language);
                        }
                        if (LiveTextView.this.liveTextViewTTS.audioAttributes != null) {
                            LiveTextView.this.textToSpeech.setAudioAttributes(LiveTextView.this.liveTextViewTTS.audioAttributes);
                        }
                        if (LiveTextView.this.liveTextViewTTS.speechRate != null) {
                            LiveTextView.this.textToSpeech.setSpeechRate(LiveTextView.this.liveTextViewTTS.speechRate.floatValue());
                        }
                        if (LiveTextView.this.liveTextViewTTS.voice != null) {
                            LiveTextView.this.textToSpeech.setVoice(LiveTextView.this.liveTextViewTTS.voice);
                        }
                    }
                } else {
                    throw new Error("An error occured initializing the Text-To-Speech Engine - Status: " + Integer.toString(status));
                }
                LiveTextView.this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

                    public void onStart(String s) {
                    }

                    public void onDone(String s) {
                        Log.i((String)"UTTERANCE", (String)s);
                        if (LiveTextView.this.currentIndex == LiveTextView.this.text.size() - 1) {
                            if (LiveTextView.this.onFinishListener != null) {
                                LiveTextView.this.onFinishListener.onFinish(LiveTextView.this);
                            }
                        } else if (!LiveTextView.this.paused) {
                            LiveTextView.this.next();
                        }
                    }

                    public void onError(String s) {
                    }
                });
                LiveTextView.this.paused = false;
                LiveTextView.this.playing = true;
                LiveTextView.this.textToSpeech.speak((CharSequence)LiveTextView.this.text.get(LiveTextView.this.currentIndex), 0, null, LiveTextView.this.text.get(LiveTextView.this.currentIndex));
                LiveTextView.this.setTextViews(null);
            }
        });
    }

    public static interface OnLoadListener {
        public void onLoad(LiveTextView var1);
    }

    public static interface OnFinishListener {
        public void onFinish(LiveTextView var1);
    }
}

