/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.constraints.NotNull;
import javax.xml.namespace.NamespaceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public final class XPathContext
implements NamespaceContext {
    private final transient ConcurrentMap<String, String> map = new ConcurrentHashMap<String, String>(0);
    private final transient Collection<NamespaceContext> contexts = new CopyOnWriteArrayList<NamespaceContext>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public XPathContext() {
        this.map.put("xhtml", "http://www.w3.org/1999/xhtml");
        this.map.put("xs", "http://www.w3.org/2001/XMLSchema");
        this.map.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.map.put("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.map.put("svg", "http://www.w3.org/2000/svg");
    }

    public XPathContext(Object ... namespaces) {
        this();
        for (int pos = 0; pos < namespaces.length; ++pos) {
            this.map.put(Logger.format((String)"ns%d", (Object[])new Object[]{pos + 1}), namespaces[pos].toString());
        }
    }

    private XPathContext(Map<String, String> old, String prefix, Object namespace) {
        this();
        this.map.putAll(old);
        if (this.map.containsKey(prefix)) {
            throw new IllegalArgumentException(String.format("prefix '%s' already registered for namespace '%s'", prefix, this.map.get(prefix)));
        }
        this.map.put(prefix, namespace.toString());
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    @Override
    public String getNamespaceURI(@NotNull(message="prefix can't be NULL") String prefix) {
        String string = prefix;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        String namespace = (String)this.map.get(prefix);
        if (namespace == null) {
            NamespaceContext ctx;
            Iterator<NamespaceContext> i$ = this.contexts.iterator();
            while (i$.hasNext() && (namespace = (ctx = i$.next()).getNamespaceURI(prefix)) == null) {
            }
        }
        if (namespace == null) {
            namespace = prefix.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : (prefix.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : "");
        }
        return namespace;
    }

    @Override
    public String getPrefix(@NotNull(message="namespace can't be NULL") String namespace) {
        String string = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Iterator<String> prefixes = this.getPrefixes(namespace);
        String prefix = null;
        if (prefixes.hasNext()) {
            prefix = prefixes.next();
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(@NotNull(message="namespaces can't be NULL") String namespace) {
        String string = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        LinkedList<Object> prefixes = new LinkedList<Object>();
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((String)entry.getValue()).equals(namespace)) continue;
            prefixes.add(entry.getKey());
        }
        for (NamespaceContext ctx : this.contexts) {
            Iterator<String> iterator = ctx.getPrefixes(namespace);
            while (iterator.hasNext()) {
                prefixes.add(iterator.next().toString());
            }
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            prefixes.add("xml");
        }
        if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
            prefixes.add("xmlns");
        }
        return Collections.unmodifiableList(prefixes).iterator();
    }

    public XPathContext add(@NotNull(message="prefix can't be NULL") String prefix, @NotNull(message="namespace can't be NULL") Object namespace) {
        String string = prefix;
        Object object = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)object);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        return new XPathContext(this.map, prefix, namespace);
    }

    public XPathContext merge(@NotNull(message="context can't be NULL") NamespaceContext context) {
        NamespaceContext namespaceContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)namespaceContext);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        XPathContext ctx = new XPathContext();
        ctx.map.putAll(this.map);
        ctx.contexts.addAll(this.contexts);
        ctx.contexts.add(context);
        return ctx;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XPathContext)) {
            return false;
        }
        XPathContext other = (XPathContext)o;
        ConcurrentMap<String, String> this$map = this.map;
        ConcurrentMap<String, String> other$map = other.map;
        if (this$map == null ? other$map != null : !this$map.equals(other$map)) {
            return false;
        }
        Collection<NamespaceContext> this$contexts = this.contexts;
        Collection<NamespaceContext> other$contexts = other.contexts;
        return !(this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts));
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        ConcurrentMap<String, String> $map = this.map;
        result = result * 277 + ($map == null ? 0 : $map.hashCode());
        Collection<NamespaceContext> $contexts = this.contexts;
        result = result * 277 + ($contexts == null ? 0 : ((Object)$contexts).hashCode());
        return result;
    }

    static {
        XPathContext.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("XPathContext.java", XPathContext.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNamespaceURI", "com.jcabi.xml.XPathContext", "java.lang.String", "prefix", "", "java.lang.String"), 132);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrefix", "com.jcabi.xml.XPathContext", "java.lang.String", "namespace", "", "java.lang.String"), 156);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrefixes", "com.jcabi.xml.XPathContext", "java.lang.String", "namespace", "", "java.util.Iterator"), 167);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "add", "com.jcabi.xml.XPathContext", "java.lang.String:java.lang.Object", "prefix:namespace", "", "com.jcabi.xml.XPathContext"), 198);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "merge", "com.jcabi.xml.XPathContext", "javax.xml.namespace.NamespaceContext", "context", "", "com.jcabi.xml.XPathContext"), 208);
    }
}

