/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.DomParser;
import com.jcabi.xml.ListWrapper;
import com.jcabi.xml.TextResource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XPathContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLDocument
implements XML {
    private final transient XPathContext context;
    private final transient boolean leaf;
    private final transient Node cache;

    public XMLDocument(Source source) {
        this(XMLDocument.transform(source));
    }

    public XMLDocument(String text) {
        this(new DomParser(XMLDocument.configuredDFactory(), text).document());
    }

    public XMLDocument(byte[] data) {
        this(new DomParser(XMLDocument.configuredDFactory(), data).document());
    }

    public XMLDocument(File file) throws FileNotFoundException {
        this(new DomParser(XMLDocument.configuredDFactory(), file).document());
    }

    public XMLDocument(Path file) throws FileNotFoundException {
        this(new DomParser(XMLDocument.configuredDFactory(), file.toFile()).document());
    }

    public XMLDocument(InputStream stream) throws IOException {
        this(new TextResource(stream).toString());
        stream.close();
    }

    public XMLDocument(URL url) throws IOException {
        this(new TextResource(url).toString());
    }

    public XMLDocument(URI uri) throws IOException {
        this(new TextResource(uri).toString());
    }

    public XMLDocument(Node node) {
        this(node, new XPathContext(), !(node instanceof Document));
    }

    private XMLDocument(Node cache, XPathContext context, boolean leaf) {
        this.context = context;
        this.leaf = leaf;
        this.cache = cache;
    }

    public String toString() {
        return XMLDocument.asString(this.cache);
    }

    public boolean equals(Object another) {
        boolean eql = !(another instanceof XML) ? false : this.toString().equals(another.toString());
        return eql;
    }

    public int hashCode() {
        return this.cache.hashCode();
    }

    @Override
    @Deprecated
    public Node node() {
        return this.deepCopy();
    }

    @Override
    public Node inner() {
        return this.cache;
    }

    @Override
    public Node deepCopy() {
        Node casted = this.cache;
        Node answer = casted instanceof Document ? casted.cloneNode(true) : XMLDocument.createImportedNode(casted);
        return answer;
    }

    @Override
    public List<String> xpath(String query) {
        List<String> items;
        try {
            NodeList nodes = this.fetch(query, NodeList.class);
            items = new ArrayList<String>(nodes.getLength());
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                short type = nodes.item(idx).getNodeType();
                if (type != 3 && type != 2 && type != 4) {
                    throw new IllegalArgumentException(String.format("Only text() nodes or attributes are retrievable with xpath() '%s': %d", query, (int)type));
                }
                items.add(nodes.item(idx).getNodeValue());
            }
        }
        catch (XPathExpressionException ex) {
            try {
                items = Collections.singletonList(this.fetch(query, String.class));
            }
            catch (XPathExpressionException exp) {
                throw new IllegalArgumentException(String.format("Invalid XPath query '%s' at %s: %s", query, XPathFactoryImpl.class.getName(), ex.getLocalizedMessage()), exp);
            }
        }
        return new ListWrapper<String>(items, this.cache, query);
    }

    @Override
    public XML registerNs(String prefix, Object uri) {
        return new XMLDocument(this.cache, this.context.add(prefix, uri), this.leaf);
    }

    @Override
    public List<XML> nodes(String query) {
        ArrayList<XMLDocument> items;
        try {
            NodeList nodes = this.fetch(query, NodeList.class);
            items = new ArrayList<XMLDocument>(nodes.getLength());
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                items.add(new XMLDocument(nodes.item(idx), this.context, true));
            }
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(String.format("Invalid XPath query '%s' by %s", query, XPathFactoryImpl.class.getName()), ex);
        }
        return new ListWrapper<XML>(items, this.cache, query);
    }

    @Override
    public XML merge(NamespaceContext ctx) {
        return new XMLDocument(this.cache, this.context.merge(ctx), this.leaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SAXParseException> validate(XML xsd) {
        XML xML = xsd;
        synchronized (xML) {
            Validator validator;
            try {
                validator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(new StringReader(xsd.toString()))).newValidator();
            }
            catch (SAXException ex) {
                throw new IllegalStateException(String.format("Failed to create XSD schema from %s", xsd), ex);
            }
            return this.validate(validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SAXParseException> validate(LSResourceResolver resolver) {
        LSResourceResolver lSResourceResolver = resolver;
        synchronized (lSResourceResolver) {
            Validator validator;
            try {
                validator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema().newValidator();
                validator.setResourceResolver(resolver);
            }
            catch (SAXException ex) {
                throw new IllegalStateException("Failed to create XSD schema", ex);
            }
            return this.validate(validator);
        }
    }

    private Collection<SAXParseException> validate(Validator validator) {
        CopyOnWriteArrayList<SAXParseException> errors = new CopyOnWriteArrayList<SAXParseException>();
        validator.setErrorHandler(new ValidationHandler(errors));
        try {
            validator.validate(new DOMSource(this.cache));
        }
        catch (IOException | SAXException ex) {
            throw new IllegalStateException(ex);
        }
        if (Logger.isDebugEnabled((Object)this)) {
            Logger.debug((Object)this, (String)"%s detected %d error(s)", (Object[])new Object[]{validator.getClass().getName(), errors.size()});
        }
        return errors;
    }

    private static Node createImportedNode(Node node) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = XMLDocument.configuredDFactory();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create document builder by %s", factory.getClass().getName()), ex);
        }
        Document document = builder.newDocument();
        Node imported = document.importNode(node, true);
        document.appendChild(imported);
        return imported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fetch(String query, Class<T> type) throws XPathExpressionException {
        QName qname;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(this.context);
        if (type.equals(String.class)) {
            qname = XPathConstants.STRING;
        } else if (type.equals(NodeList.class)) {
            qname = XPathConstants.NODESET;
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type: %s", type.getName()));
        }
        Node node = this.cache;
        synchronized (node) {
            return (T)xpath.evaluate(query, this.cache, qname);
        }
    }

    private static String asString(Node node) {
        Transformer trans;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            trans = factory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create transformer by %s", XPathFactoryImpl.class.getName()), ex);
        }
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("version", "1.0");
        if (!(node instanceof Document)) {
            trans.setOutputProperty("omit-xml-declaration", "yes");
        }
        DOMSource source = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IllegalArgumentException(String.format("Failed to transform %s to %s", source.getClass().getName(), result.getClass().getName()), ex);
        }
        return writer.toString();
    }

    private static Node transform(Source source) {
        DOMResult result = new DOMResult();
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer trans = factory.newTransformer();
            trans.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IllegalArgumentException(String.format("Failed to transform %s to %s", source.getClass().getName(), result.getClass().getName()), ex);
        }
        return result.getNode();
    }

    private static DocumentBuilderFactory configuredDFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (factory.getClass().getName().contains("xerces")) {
            try {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException ex) {
                throw new IllegalStateException(ex);
            }
        }
        factory.setNamespaceAware(true);
        return factory;
    }

    static final class ValidationHandler
    implements ErrorHandler {
        private final transient Collection<SAXParseException> errors;

        ValidationHandler(Collection<SAXParseException> errs) {
            this.errors = errs;
        }

        @Override
        public void warning(SAXParseException error) {
            this.errors.add(error);
        }

        @Override
        public void error(SAXParseException error) {
            this.errors.add(error);
        }

        @Override
        public void fatalError(SAXParseException error) {
            this.errors.add(error);
        }
    }
}

