/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.xml.DomParser;
import com.jcabi.xml.ListWrapper;
import com.jcabi.xml.TextResource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XPathContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLDocument
implements XML {
    private static final XPathFactory XFACTORY = XPathFactory.newInstance();
    private static final TransformerFactory TFACTORY = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory DFACTORY = DocumentBuilderFactory.newInstance();
    private final transient XPathContext context;
    private final transient boolean leaf;
    private final transient Node cache;

    public XMLDocument(String text) {
        this(new DomParser(DFACTORY, text).document(), new XPathContext(), false);
    }

    public XMLDocument(byte[] data) {
        this(new DomParser(DFACTORY, data).document(), new XPathContext(), false);
    }

    public XMLDocument(Node node) {
        this(node, new XPathContext(), !(node instanceof Document));
    }

    public XMLDocument(Source source) {
        this(XMLDocument.transform(source), new XPathContext(), false);
    }

    public XMLDocument(File file) throws FileNotFoundException {
        this(new TextResource(file).toString());
    }

    public XMLDocument(Path file) throws FileNotFoundException {
        this(file.toFile());
    }

    public XMLDocument(URL url) throws IOException {
        this(new TextResource(url).toString());
    }

    public XMLDocument(URI uri) throws IOException {
        this(new TextResource(uri).toString());
    }

    public XMLDocument(InputStream stream) throws IOException {
        this(new TextResource(stream).toString());
        stream.close();
    }

    private XMLDocument(Node node, XPathContext ctx, boolean lfe) {
        this.context = ctx;
        this.leaf = lfe;
        this.cache = node;
    }

    public String toString() {
        return XMLDocument.asString(this.cache);
    }

    public boolean equals(Object another) {
        boolean eql = !(another instanceof XML) ? false : this.toString().equals(another.toString());
        return eql;
    }

    public int hashCode() {
        return this.cache.hashCode();
    }

    @Override
    public Node node() {
        Node casted = (Node)Node.class.cast(this.cache);
        Node answer = casted instanceof Document ? casted.cloneNode(true) : XMLDocument.createImportedNode(casted);
        return answer;
    }

    @Override
    public List<String> xpath(String query) {
        List<String> items;
        try {
            NodeList nodes = this.fetch(query, NodeList.class);
            items = new ArrayList<String>(nodes.getLength());
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                short type = nodes.item(idx).getNodeType();
                if (type != 3 && type != 2 && type != 4) {
                    throw new IllegalArgumentException(String.format("Only text() nodes or attributes are retrievable with xpath() '%s': %d", query, (int)type));
                }
                items.add(nodes.item(idx).getNodeValue());
            }
        }
        catch (XPathExpressionException ex) {
            try {
                items = Collections.singletonList(this.fetch(query, String.class));
            }
            catch (XPathExpressionException exp) {
                throw new IllegalArgumentException(String.format("Invalid XPath query '%s' at %s: %s", query, XFACTORY.getClass().getName(), ex.getLocalizedMessage()), exp);
            }
        }
        return new ListWrapper<String>(items, (Node)Node.class.cast(this.cache), query);
    }

    @Override
    public XML registerNs(String prefix, Object uri) {
        return new XMLDocument((Node)Node.class.cast(this.cache), this.context.add(prefix, uri), this.leaf);
    }

    @Override
    public List<XML> nodes(String query) {
        ArrayList<XMLDocument> items;
        try {
            NodeList nodes = this.fetch(query, NodeList.class);
            items = new ArrayList<XMLDocument>(nodes.getLength());
            for (int idx = 0; idx < nodes.getLength(); ++idx) {
                items.add(new XMLDocument(nodes.item(idx), this.context, true));
            }
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(String.format("Invalid XPath query '%s' by %s", query, XFACTORY.getClass().getName()), ex);
        }
        return new ListWrapper<XML>(items, (Node)Node.class.cast(this.cache), query);
    }

    @Override
    public XML merge(NamespaceContext ctx) {
        return new XMLDocument((Node)Node.class.cast(this.cache), this.context.merge(ctx), this.leaf);
    }

    private static Node createImportedNode(Node node) {
        DocumentBuilder builder;
        try {
            builder = DFACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create document builder by %s", DFACTORY.getClass().getName()), ex);
        }
        Document document = builder.newDocument();
        Node imported = document.importNode(node, true);
        document.appendChild(imported);
        return imported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fetch(String query, Class<T> type) throws XPathExpressionException {
        Class<XMLDocument> clazz = XMLDocument.class;
        synchronized (XMLDocument.class) {
            QName qname;
            XPath xpath = XFACTORY.newXPath();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            xpath.setNamespaceContext(this.context);
            if (type.equals(String.class)) {
                qname = XPathConstants.STRING;
            } else if (type.equals(NodeList.class)) {
                qname = XPathConstants.NODESET;
            } else {
                throw new IllegalArgumentException(String.format("Unsupported type: %s", type.getName()));
            }
            return (T)xpath.evaluate(query, Node.class.cast(this.cache), qname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String asString(Node node) {
        Transformer trans;
        StringWriter writer = new StringWriter();
        try {
            Class<XMLDocument> clazz = XMLDocument.class;
            synchronized (XMLDocument.class) {
                trans = TFACTORY.newTransformer();
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        catch (TransformerConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create transformer by %s", TFACTORY.getClass().getName()), ex);
        }
        {
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("version", "1.0");
            if (!(node instanceof Document)) {
                trans.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            try {
                Node node2 = node;
                synchronized (node2) {
                    trans.transform(source, result);
                }
            }
            catch (TransformerException ex) {
                throw new IllegalArgumentException(String.format("Failed to transform %s to %s", source.getClass().getName(), result.getClass().getName()), ex);
            }
            return writer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node transform(Source source) {
        DOMResult result = new DOMResult();
        try {
            Class<XMLDocument> clazz = XMLDocument.class;
            synchronized (XMLDocument.class) {
                Transformer trans = TFACTORY.newTransformer();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                trans.transform(source, result);
            }
        }
        catch (TransformerException ex) {
            throw new IllegalArgumentException(String.format("Failed to transform %s to %s", source.getClass().getName(), result.getClass().getName()), ex);
        }
        return result.getNode();
    }

    static {
        if (DFACTORY.getClass().getName().contains("xerces")) {
            try {
                DFACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException ex) {
                throw new IllegalStateException(ex);
            }
        }
        DFACTORY.setNamespaceAware(true);
    }
}

