/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.xml.Sources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;

public final class FileSources
implements Sources {
    private final transient File path;

    public FileSources() {
        this("");
    }

    public FileSources(String dir) {
        this(new File(dir));
    }

    public FileSources(File dir) {
        this.path = dir;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        File file = new File(this.path, href);
        if (!file.exists() && !(file = base == null ? new File(href) : new File(new File(base), href)).exists()) {
            throw new TransformerException(String.format("file \"%s\" not found in \"%s\" and in base \"%s\"", href, this.path, base));
        }
        try {
            return new StreamSource(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new TransformerException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSources)) {
            return false;
        }
        FileSources other = (FileSources)o;
        File this$path = this.path;
        File other$path = other.path;
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $path = this.path;
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }
}

