/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.immutable.ArrayMap;
import com.jcabi.log.Logger;
import com.jcabi.xml.Sources;
import com.jcabi.xml.TextResource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public final class XSLDocument
implements XSL {
    public static final XSL STRIP = XSLDocument.make(XSL.class.getResourceAsStream("strip.xsl"));
    private static final DocumentBuilderFactory DFACTORY = DocumentBuilderFactory.newInstance();
    private static final ErrorListener ERRORS = new ErrorListener(){

        @Override
        public void warning(TransformerException exception) {
            Logger.warn((Object)this, (String)exception.getMessageAndLocation());
        }

        @Override
        public void error(TransformerException exception) {
            Logger.error((Object)this, (String)exception.getMessageAndLocation());
        }

        @Override
        public void fatalError(TransformerException exception) {
            this.error(exception);
        }
    };
    private final transient String xsl;
    private final transient Sources sources;
    private final transient ArrayMap<String, String> params;

    public XSLDocument(@NotNull(message="XML can't be NULL") XML src) {
        this(src.toString());
    }

    public XSLDocument(@NotNull(message="URL can't be NULL") URL url) throws IOException {
        this(new TextResource(url).toString());
    }

    public XSLDocument(@NotNull(message="URI can't be NULL") URI uri) throws IOException {
        this(new TextResource(uri).toString());
    }

    public XSLDocument(@NotNull(message="XSL input stream can't be NULL") InputStream stream) {
        this(new TextResource(stream).toString());
    }

    public XSLDocument(String src) {
        this(src, Sources.DUMMY);
    }

    public XSLDocument(String src, Sources srcs) {
        this(src, srcs, (Map<String, String>)new ArrayMap());
    }

    public XSLDocument(@NotNull(message="XSL can't be NULL") String src, @NotNull(message="sources can't be NULL") Sources srcs, @NotNull(message="map of params can't be NULL") Map<String, String> map) {
        this.xsl = src;
        this.sources = srcs;
        this.params = new ArrayMap(map);
    }

    @Override
    public XSL with(@NotNull(message="sources can't be NULL") Sources src) {
        return new XSLDocument(this.xsl, src, (Map<String, String>)this.params);
    }

    @Override
    public XSL with(@NotNull(message="name can't be NULL") String name, @NotNull(message="value can't be NULL") String value) {
        return new XSLDocument(this.xsl, this.sources, (Map<String, String>)this.params.with((Object)name, (Object)value));
    }

    public static XSL make(@NotNull(message="XSL input stream can't be NULL") InputStream stream) {
        return new XSLDocument(stream);
    }

    public static XSL make(@NotNull(message="URL can't be NULL") URL url) {
        try {
            return new XSLDocument(url);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return new XMLDocument(this.xsl).toString();
    }

    @Override
    @NotNull(message="XML is never NULL")
    public XML transform(@NotNull(message="XML can't be NULL") XML xml) {
        Document target;
        try {
            target = DFACTORY.newDocumentBuilder().newDocument();
            this.transformInto(xml, new DOMResult(target));
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        return new XMLDocument(target);
    }

    @Override
    public String applyTo(@NotNull(message="XML can't be NULL") XML xml) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformInto(xml, new StreamResult(baos));
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformInto(XML xml, Result result) {
        Class<XSLDocument> clazz = XSLDocument.class;
        synchronized (XSLDocument.class) {
            Transformer trans;
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setErrorListener(ERRORS);
                factory.setURIResolver(this.sources);
                trans = factory.newTransformer(new StreamSource(new StringReader(this.xsl)));
                trans.setURIResolver(this.sources);
                for (Map.Entry ent : this.params.entrySet()) {
                    trans.setParameter((String)ent.getKey(), ent.getValue());
                }
                trans.transform(new DOMSource(xml.node()), result);
            }
            catch (TransformerConfigurationException ex) {
                throw new IllegalStateException(String.format("failed to configure transformer by %s", factory.getClass().getName()), ex);
            }
            catch (TransformerException ex) {
                throw new IllegalStateException(String.format("failed to transform by %s", factory.getClass().getName()), ex);
            }
            Logger.debug((Object)this, (String)"%s transformed XML", (Object[])new Object[]{trans.getClass().getName()});
            return;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSLDocument)) {
            return false;
        }
        XSLDocument other = (XSLDocument)o;
        String this$xsl = this.xsl;
        String other$xsl = other.xsl;
        return !(this$xsl == null ? other$xsl != null : !this$xsl.equals(other$xsl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xsl = this.xsl;
        result = result * 59 + ($xsl == null ? 43 : $xsl.hashCode());
        return result;
    }
}

