/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.aspects.RetryOnFailure;
import com.jcabi.ssh.AbstractSshShell;
import com.jcabi.ssh.EasyRepo;
import com.jcabi.ssh.JschLogger;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.io.TeeInput;
import org.cactoos.scalar.LengthOf;
import org.cactoos.scalar.Unchecked;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;

public final class Ssh
extends AbstractSshShell {
    public static final int PORT = 22;
    private final transient String key;
    private final transient String passphrase;

    public Ssh(String adr, String user, URL priv) throws IOException {
        this(adr, 22, user, priv);
    }

    public Ssh(InetAddress adr, String user, URL priv) throws IOException {
        this(adr, 22, user, priv);
    }

    public Ssh(String adr, String user, String priv) throws UnknownHostException {
        this(adr, 22, user, priv);
    }

    public Ssh(InetAddress adr, String user, String priv) throws UnknownHostException {
        this(adr.getCanonicalHostName(), 22, user, priv);
    }

    public Ssh(String adr, int prt, String user, URL priv) throws IOException {
        this(adr, prt, user, new UncheckedText((Text)new TextOf(priv)).asString());
    }

    public Ssh(InetAddress adr, int prt, String user, URL priv) throws IOException {
        this(adr.getCanonicalHostName(), prt, user, new UncheckedText((Text)new TextOf(priv)).asString());
    }

    public Ssh(String adr, int prt, String user, String priv) throws UnknownHostException {
        this(adr, prt, user, priv, null);
    }

    public Ssh(String adr, int prt, String user, String priv, String passphrs) throws UnknownHostException {
        super(adr, prt, user);
        this.key = priv;
        this.passphrase = passphrs;
    }

    public static String escape(String arg) {
        return String.format("'%s'", arg.replace("'", "'\\''"));
    }

    @Override
    @RetryOnFailure(attempts=7, delay=1L, unit=TimeUnit.MINUTES, verbose=false, types={IOException.class})
    protected Session session() throws IOException {
        File file = File.createTempFile("jcabi-ssh", ".key");
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            JSch.setLogger((Logger)new JschLogger());
            JSch jsch = new JSch();
            new Unchecked((Scalar)new LengthOf((Input)new TeeInput((CharSequence)this.key.replaceAll("\r", "").replaceAll("\n\\s+|\n{2,}", "\n").trim(), file))).value();
            jsch.setHostKeyRepository((HostKeyRepository)new EasyRepo());
            if (this.passphrase == null) {
                jsch.addIdentity(file.getAbsolutePath());
            } else {
                jsch.addIdentity(this.getLogin(), this.key.getBytes(StandardCharsets.UTF_8), null, this.passphrase.getBytes(StandardCharsets.UTF_8));
            }
            com.jcabi.log.Logger.debug((Object)this, (String)"Opening SSH session to %s@%s:%s (%d bytes in RSA key)...", (Object[])new Object[]{this.getLogin(), this.getAddr(), this.getPort(), file.length()});
            Session session = jsch.getSession(this.getLogin(), this.getAddr(), this.getPort());
            session.setTimeout((int)TimeUnit.MINUTES.toMillis(1L));
            session.setServerAliveInterval((int)TimeUnit.SECONDS.toMillis(1L));
            session.setServerAliveCountMax(1000000);
            session.connect();
            com.jcabi.log.Logger.debug((Object)this, (String)"SSH session opened to %s@%s:%s", (Object[])new Object[]{this.getLogin(), this.getAddr(), this.getPort()});
            Session session2 = session;
            return session2;
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
        finally {
            Files.deleteIfExists(file.toPath());
        }
    }

    @Override
    public String toString() {
        return "Ssh(key=" + this.key + ", passphrase=" + this.passphrase + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ssh)) {
            return false;
        }
        Ssh other = (Ssh)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Ssh;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

