/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.ssh.Execution;
import com.jcabi.ssh.Shell;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

abstract class AbstractSshShell
implements Shell {
    private final transient String addr;
    private final transient int port;
    private final transient String login;

    AbstractSshShell(String adr, int prt, String user) throws UnknownHostException {
        this.addr = InetAddress.getByName(adr).getHostAddress();
        this.port = prt;
        this.login = user;
    }

    @Override
    public int exec(String command, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        return new Execution.Default(command, stdin, stdout, stderr, this.session()).exec();
    }

    protected abstract Session session() throws IOException;

    public String toString() {
        return "AbstractSshShell(addr=" + this.getAddr() + ", port=" + this.getPort() + ", login=" + this.getLogin() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSshShell)) {
            return false;
        }
        AbstractSshShell other = (AbstractSshShell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$addr = this.getAddr();
        String other$addr = other.getAddr();
        if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        return !(this$login == null ? other$login != null : !this$login.equals(other$login));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSshShell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $addr = this.getAddr();
        result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        return result;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String getLogin() {
        return this.login;
    }
}

