/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.immutable;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.immutable.ArrayComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

@Immutable
@Loggable(value=1)
public final class ArraySortedSet<T>
implements SortedSet<T> {
    @Immutable.Array
    private final transient T[] values;
    private final transient ArrayComparator<T> cmp;

    public ArraySortedSet(ArrayComparator<T> comparator) {
        this(comparator, new Object[0]);
    }

    public ArraySortedSet(T ... set) {
        this((Iterable<T>)Arrays.asList(set));
    }

    public ArraySortedSet(ArrayComparator<T> comparator, T ... set) {
        this((Collection<T>)Arrays.asList(set), comparator);
    }

    public ArraySortedSet(Iterable<T> set) {
        this(set, (ArrayComparator<T>)new ArrayComparator.Default());
    }

    public ArraySortedSet(ArraySortedSet<T> set, ArrayComparator<T> comparator) {
        this.throwIfArgumentIsNull(set, "arraySortedSet argument of ArraySortedSet ctor can't be NULL");
        this.throwIfComparatorArgumentIsNull(comparator);
        this.cmp = comparator;
        ArraySortedSet<T> origin = set;
        if (origin.cmp.equals(this.cmp)) {
            this.values = origin.values;
        } else {
            TreeSet<Object> hset = new TreeSet<Object>(this.cmp);
            hset.addAll((Collection)Collection.class.cast(set));
            this.values = hset.toArray(new Object[hset.size()]);
        }
    }

    public ArraySortedSet(Collection<T> set, ArrayComparator<T> comparator) {
        this.throwIfArgumentIsNull(set, "collection argument of ArraySortedSet ctor can't be NULL");
        this.throwIfComparatorArgumentIsNull(comparator);
        this.cmp = comparator;
        TreeSet<Object> hset = new TreeSet<Object>(this.cmp);
        hset.addAll((Collection)Collection.class.cast(set));
        this.values = hset.toArray(new Object[hset.size()]);
    }

    public ArraySortedSet(Iterable<T> set, ArrayComparator<T> comparator) {
        this.throwIfArgumentIsNull(set, "iterable argument of ArraySortedSet ctor can't be NULL");
        this.throwIfComparatorArgumentIsNull(comparator);
        this.cmp = comparator;
        TreeSet<Object> hset = new TreeSet<Object>(this.cmp);
        for (T item : set) {
            hset.add(item);
        }
        this.values = hset.toArray(new Object[hset.size()]);
    }

    public ArraySortedSet<T> with(T value) {
        this.throwIfArgumentIsNull(value, "argument of ArraySortedSet#with() can't be NULL");
        TreeSet<T> list = new TreeSet<T>(this.cmp);
        list.addAll(this);
        list.remove(value);
        list.add(value);
        return new ArraySortedSet<T>(list, this.cmp);
    }

    public ArraySortedSet<T> with(Collection<T> vals) {
        this.throwIfArgumentIsNull(vals, "arguments of ArraySortedSet#with() can't be NULL");
        TreeSet<T> list = new TreeSet<T>(this.cmp);
        list.addAll(this);
        list.removeAll(vals);
        list.addAll(vals);
        return new ArraySortedSet<T>(list, this.cmp);
    }

    public ArraySortedSet<T> without(T value) {
        this.throwIfArgumentIsNull(value, "argument of ArraySortedSet#without() can't be NULL");
        TreeSet<T> list = new TreeSet<T>(this.cmp);
        list.addAll(this);
        list.remove(value);
        return new ArraySortedSet<T>(list, this.cmp);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ArraySortedSet && Arrays.deepEquals(this.values, ((ArraySortedSet)ArraySortedSet.class.cast((Object)object)).values);
    }

    public String toString() {
        StringBuilder text = new StringBuilder(0);
        for (T item : this.values) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(item);
        }
        return text.toString();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean contains(Object key) {
        return Arrays.asList(this.values).contains(key);
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.cmp;
    }

    @Override
    public SortedSet<T> subSet(T from, T till) {
        return Collections.unmodifiableSortedSet(new TreeSet<T>(this).subSet(from, till));
    }

    @Override
    public SortedSet<T> headSet(T till) {
        return Collections.unmodifiableSortedSet(new TreeSet(this)).headSet(till);
    }

    @Override
    public SortedSet<T> tailSet(T from) {
        return Collections.unmodifiableSortedSet(new TreeSet(this)).tailSet(from);
    }

    @Override
    public T first() {
        if (this.values.length == 0) {
            throw new NoSuchElementException("sorted set is empty, no first()");
        }
        return this.values[0];
    }

    @Override
    public T last() {
        if (this.values.length == 0) {
            throw new NoSuchElementException("sorted set is empty, not last()");
        }
        return this.values[this.values.length - 1];
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.values)).iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.values.length];
        System.arraycopy(this.values, 0, array, 0, this.values.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] dest = array.length == this.values.length ? array : new Object[this.values.length];
        System.arraycopy(this.values, 0, dest, 0, this.values.length);
        return dest;
    }

    @Override
    @Deprecated
    public boolean add(T element) {
        throw new UnsupportedOperationException("add(): ArraySortedSet is immutable");
    }

    @Override
    @Deprecated
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException("remove(): ArraySortedSet is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return Arrays.asList(this.values).containsAll(col);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends T> col) {
        throw new UnsupportedOperationException("addAll(): ArraySortedSet is immutable");
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> col) {
        throw new UnsupportedOperationException("retainAll(): ArraySortedSet is immutable");
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> col) {
        throw new UnsupportedOperationException("removeAll(): ArraySortedSet is immutable");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("clear(): ArraySortedSet is immutable");
    }

    private void throwIfComparatorArgumentIsNull(Comparator<T> comp) {
        this.throwIfArgumentIsNull(comp, "comparator argument of ArraySortedSet ctor can't be NULL");
    }

    private void throwIfArgumentIsNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

