/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.immutable;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Immutable
@Loggable(value=1)
public final class ArrayMap<K, V>
implements ConcurrentMap<K, V> {
    @Immutable.Array
    private final transient ImmutableEntry<K, V>[] entries;

    public ArrayMap() {
        this.entries = new ImmutableEntry[0];
    }

    public ArrayMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("argument of ArrayMap ctor can't be NULL");
        }
        TreeSet entrs = new TreeSet(new Cmp());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entrs.add(new ImmutableEntry(entry));
        }
        this.entries = entrs.toArray(new ImmutableEntry[0]);
    }

    public ArrayMap<K, V> with(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("first argument of ArrayMap#with() can't be NULL");
        }
        if (value == null) {
            throw new IllegalArgumentException("second argument of ArrayMap#with() can't be NULL");
        }
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(this.entries.length);
        map.putAll(this);
        map.put(key, value);
        return new ArrayMap(map);
    }

    public ArrayMap<K, V> with(Map<K, V> ents) {
        if (ents == null) {
            throw new IllegalArgumentException("arguments of ArrayMap#with() can't be NULL");
        }
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(this.entries.length);
        map.putAll(this);
        map.putAll(ents);
        return new ArrayMap(map);
    }

    public ArrayMap<K, V> without(K key) {
        if (key == null) {
            throw new IllegalArgumentException("argument of ArrayMap#without() can't be NULL");
        }
        ConcurrentHashMap map = new ConcurrentHashMap(this.entries.length);
        map.putAll(this);
        map.remove(key);
        return new ArrayMap(map);
    }

    public ArrayMap<K, V> without(Collection<K> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("arguments of ArrayMap#without() can't be NULL");
        }
        ConcurrentHashMap map = new ConcurrentHashMap(this.entries.length);
        map.putAll(this);
        for (K key : keys) {
            map.remove(key);
        }
        return new ArrayMap(map);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ArrayMap && Arrays.deepEquals(this.entries, ((ArrayMap)ArrayMap.class.cast((Object)object)).entries);
    }

    public String toString() {
        StringBuilder text = new StringBuilder(0);
        for (ImmutableEntry<K, V> item : this.entries) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(item);
        }
        return text.toString();
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean contains = false;
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean contains = false;
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (!entry.getValue().equals(value)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @Override
    public V get(Object key) {
        V value = null;
        for (ImmutableEntry<K, V> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            value = entry.getValue();
            break;
        }
        return value;
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException("put(): ArrayMap is immutable");
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException("remove(): ArrayMap is immutable");
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("putAll(): ArrayMap is immutable");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("clear(): ArrayMap is immutable");
    }

    @Override
    @Deprecated
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("putIfAbsent(): ArrayMap is immutable");
    }

    @Override
    @Deprecated
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("remove(): ArrayMap is immutable, can't change");
    }

    @Override
    @Deprecated
    public boolean replace(K key, V old, V value) {
        throw new UnsupportedOperationException("replace(): ArrayMap is immutable");
    }

    @Override
    @Deprecated
    public V replace(K key, V value) {
        throw new UnsupportedOperationException("replace(): ArrayMap is immutable, can't replace");
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet keys = new LinkedHashSet(this.entries.length);
        for (ImmutableEntry<K, V> entry : this.entries) {
            keys.add(entry.getKey());
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList(this.entries.length);
        for (ImmutableEntry<K, V> entry : this.entries) {
            values.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(new LinkedHashSet<ImmutableEntry<K, V>>(Arrays.asList(this.entries)));
    }

    @Immutable
    private static final class ImmutableEntry<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private static final long serialVersionUID = 1L;

        private ImmutableEntry(Map.Entry<K, V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        private ImmutableEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public String toString() {
            return String.format("%s=%s", this.getKey(), this.getValue());
        }
    }

    private static final class Cmp<K, V>
    implements Comparator<ImmutableEntry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 4064118000237204080L;

        private Cmp() {
        }

        @Override
        public int compare(ImmutableEntry<K, V> left, ImmutableEntry<K, V> right) {
            int compare = left.getKey() instanceof Comparable ? ((Comparable)Comparable.class.cast(left.getKey())).compareTo(right.getKey()) : left.getKey().toString().compareTo(right.getKey().toString());
            return compare;
        }
    }
}

