/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.immutable;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

@Immutable
@Loggable(value=1)
public final class Array<T>
implements List<T> {
    private final transient T[] values;

    public Array() {
        this(new Object[0]);
    }

    public Array(T ... list) {
        this.values = list;
    }

    public Array(Iterable<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list of objects can't be NULL");
        }
        if (list instanceof Array) {
            this.values = ((Array)list).values;
        } else if (list instanceof Collection) {
            Collection col = (Collection)Collection.class.cast(list);
            this.values = new Object[col.size()];
            col.toArray(this.values);
        } else {
            LinkedList<T> items = new LinkedList<T>();
            for (T item : list) {
                items.add(item);
            }
            this.values = new Object[items.size()];
            items.toArray(this.values);
        }
    }

    public Array<T> with(T value) {
        if (value == null) {
            throw new IllegalArgumentException("argument of Array#with() can't be NULL");
        }
        Object[] items = new Object[this.values.length + 1];
        System.arraycopy(this.values, 0, items, 0, this.values.length);
        items[this.values.length] = value;
        return new Array<Object>(items);
    }

    public Array<T> with(Iterable<T> vals) {
        Array<Object> array;
        if (vals == null) {
            throw new IllegalArgumentException("arguments of Array#with() can't be NULL");
        }
        if (vals instanceof Collection) {
            Object[] items = new Object[this.values.length + ((Collection)Collection.class.cast(vals)).size()];
            System.arraycopy(this.values, 0, items, 0, this.values.length);
            int idx = this.values.length;
            for (T value : vals) {
                items[idx] = value;
                ++idx;
            }
            array = new Array<Object>(items);
        } else {
            LinkedList<T> list = new LinkedList<T>();
            list.addAll(Arrays.asList(this.values));
            for (T value : vals) {
                list.add(value);
            }
            array = new Array(list);
        }
        return array;
    }

    public Array<T> with(int pos, T value) {
        if (value == null) {
            throw new IllegalArgumentException("second argument of Array#with() can't be NULL");
        }
        Object[] temp = new Object[Math.max(this.values.length, pos + 1)];
        System.arraycopy(this.values, 0, temp, 0, this.values.length);
        temp[pos] = value;
        return new Array<Object>(temp);
    }

    public Array<T> without(int idx) {
        if (idx >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("index %d is out of bounds: [0..%d]", idx, this.values.length));
        }
        Object[] items = new Object[this.values.length - 1];
        System.arraycopy(this.values, 0, items, 0, idx);
        System.arraycopy(this.values, idx + 1, items, idx, this.values.length - idx - 1);
        return new Array<Object>(items);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Array && Arrays.deepEquals(this.values, ((Array)Array.class.cast((Object)object)).values);
    }

    public String toString() {
        StringBuilder text = new StringBuilder(0);
        for (T item : this.values) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(item);
        }
        return text.toString();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean contains(Object key) {
        return Arrays.asList(this.values).contains(key);
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.values)).iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.values.length];
        System.arraycopy(this.values, 0, array, 0, this.values.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] target = array.length == this.values.length ? array : new Object[this.values.length];
        System.arraycopy(this.values, 0, target, 0, this.values.length);
        return target;
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("add(): Array is immutable");
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException("remove(): Array is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return Arrays.asList(this.values).containsAll(col);
    }

    @Override
    public boolean addAll(Collection<? extends T> col) {
        throw new UnsupportedOperationException("addAll(): Array is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        throw new UnsupportedOperationException("retainAll(): Array is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        throw new UnsupportedOperationException("removeAll(): Array is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear(): Array is immutable");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> col) {
        throw new UnsupportedOperationException("addAll(): Array is immutable, can't change");
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new IndexOutOfBoundsException(String.format("index %d is out of bounds, length=%d", index, this.values.length));
        }
        return this.values[index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("set(idx): Array is immutable");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("add(idx): Array is immutable");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("remove(idx): Array is immutable");
    }

    @Override
    public int indexOf(Object obj) {
        return Arrays.asList(this.values).indexOf(obj);
    }

    @Override
    public int lastIndexOf(Object obj) {
        return Arrays.asList(this.values).lastIndexOf(obj);
    }

    @Override
    public ListIterator<T> listIterator() {
        return Collections.unmodifiableList(Arrays.asList(this.values)).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return Collections.unmodifiableList(Arrays.asList(this.values)).listIterator(index);
    }

    @Override
    public List<T> subList(int from, int till) {
        return Collections.unmodifiableList(Arrays.asList(this.values).subList(from, till));
    }
}

