/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.log.Logger;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@Immutable
public final class RestResponse
extends AbstractResponse {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public RestResponse(@NotNull(message="response can't be NULL") Response resp) {
        super(resp);
        Response response = resp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)response);
        try {
            MethodValidator.aspectOf().beforeCtor(joinPoint);
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @NotNull(message="new response is never NULL")
    public RestResponse assertThat(@NotNull(message="matcher can't be NULL") Matcher<Response> matcher) {
        RestResponse restResponse;
        RestResponse restResponse2;
        Matcher<Response> matcher2 = matcher;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, matcher2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        MatcherAssert.assertThat((String)String.format("HTTP response is not valid: %s", this), (Object)this, matcher);
        RestResponse restResponse3 = restResponse2 = (restResponse = this);
        MethodValidator.aspectOf().after(joinPoint, (Object)restResponse2);
        return restResponse;
    }

    @NotNull(message="response is never NULL")
    public RestResponse assertStatus(int status) {
        RestResponse restResponse;
        RestResponse restResponse2;
        int n = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        String message = String.format("HTTP response with status %d", status);
        MatcherAssert.assertThat((String)String.format("HTTP response status is not equal to %d:%n%s", status, this), (Object)this, (Matcher)new StatusMatch(message, status));
        RestResponse restResponse3 = restResponse2 = (restResponse = this);
        MethodValidator.aspectOf().after(joinPoint, (Object)restResponse2);
        return restResponse;
    }

    @NotNull(message="REST response is never NULL")
    public RestResponse assertStatus(@NotNull(message="status matcher can't be NULL") Matcher<Integer> matcher) {
        RestResponse restResponse;
        RestResponse restResponse2;
        Matcher<Integer> matcher2 = matcher;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, matcher2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        MatcherAssert.assertThat((String)String.format("HTTP response status is not the one expected:%n%s", this), (Object)this.status(), matcher);
        RestResponse restResponse3 = restResponse2 = (restResponse = this);
        MethodValidator.aspectOf().after(joinPoint, (Object)restResponse2);
        return restResponse;
    }

    @NotNull(message="REST response is never NULL")
    public RestResponse assertBody(@NotNull(message="body matcher can't be NULL") Matcher<String> matcher) {
        RestResponse restResponse;
        RestResponse restResponse2;
        Matcher<String> matcher2 = matcher;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, matcher2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        MatcherAssert.assertThat((String)String.format("HTTP response body content is not valid:%n%s", this), (Object)this.body(), matcher);
        RestResponse restResponse3 = restResponse2 = (restResponse = this);
        MethodValidator.aspectOf().after(joinPoint, (Object)restResponse2);
        return restResponse;
    }

    @NotNull(message="response is never NULL")
    public RestResponse assertHeader(@NotNull(message="header name can't be NULL") String name, @NotNull(message="header matcher can't be NULL") Matcher<Iterable<String>> matcher) {
        RestResponse restResponse;
        RestResponse restResponse2;
        String string = name;
        Matcher<Iterable<String>> matcher2 = matcher;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, matcher2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        List values = this.headers().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        MatcherAssert.assertThat((String)String.format("HTTP header '%s' is not valid:%n%s", name, this), values, matcher);
        RestResponse restResponse3 = restResponse2 = (restResponse = this);
        MethodValidator.aspectOf().after(joinPoint, (Object)restResponse2);
        return restResponse;
    }

    @NotNull(message="response is never NULL")
    public RestResponse assertHeader(@NotNull(message="header name can't be NULL") String name, @NotNull(message="header value can't be NULL") String value) {
        RestResponse restResponse;
        RestResponse restResponse2;
        String string = name;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        RestResponse restResponse3 = restResponse2 = (restResponse = this.assertHeader(name, (Matcher<Iterable<String>>)Matchers.hasItems((Object[])new String[]{value})));
        MethodValidator.aspectOf().after(joinPoint, (Object)restResponse2);
        return restResponse;
    }

    @NotNull(message="request is never NULL")
    public Request jump(@NotNull(message="URI can't be NULL") URI uri) {
        Request request;
        Request request2;
        URI uRI = uri;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)uRI);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Request req = this.back().uri().set(this.back().uri().get().resolve(uri)).back();
        Map<String, List<String>> headers = this.headers();
        if (headers.containsKey("Set-Cookie")) {
            for (String header : headers.get("Set-Cookie")) {
                for (HttpCookie cookie : HttpCookie.parse(header)) {
                    req = req.header("Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue()));
                }
            }
        }
        Request request3 = request2 = (request = req);
        MethodValidator.aspectOf().after(joinPoint, (Object)request2);
        return request;
    }

    @NotNull(message="request is never NULL")
    public Request follow() {
        Request request;
        Request request2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        this.assertHeader("Location", (Matcher<Iterable<String>>)Matchers.not((Matcher)Matchers.emptyIterableOf(String.class)));
        Request request3 = request2 = (request = this.jump(URI.create(this.headers().get("Location").get(0))));
        MethodValidator.aspectOf().after(joinPoint, (Object)request2);
        return request;
    }

    @NotNull(message="cookie is never NULL")
    public Cookie cookie(@NotNull String name) {
        Cookie cookie;
        Cookie cookie2;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Map<String, List<String>> headers = this.headers();
        MatcherAssert.assertThat((String)"cookies should be set in HTTP header", (boolean)headers.containsKey("Set-Cookie"));
        String header = StringUtils.join((Iterable)headers.get("Set-Cookie"), (String)", ");
        Cookie cookie3 = null;
        for (HttpCookie candidate : HttpCookie.parse(header)) {
            if (!candidate.getName().equals(name)) continue;
            cookie3 = RestResponse.cookie(candidate);
            break;
        }
        MatcherAssert.assertThat((String)Logger.format((String)"cookie '%s' not found in Set-Cookie header: '%s'", (Object[])new Object[]{name, header}), (Object)cookie3, (Matcher)Matchers.notNullValue());
        assert (cookie3 != null);
        Cookie cookie4 = cookie2 = (cookie = cookie3);
        MethodValidator.aspectOf().after(joinPoint, (Object)cookie2);
        return cookie;
    }

    private static Cookie cookie(HttpCookie cookie) {
        return new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResponse)) {
            return false;
        }
        RestResponse other = (RestResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof RestResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        result = result * 277 + super.hashCode();
        return result;
    }

    static {
        RestResponse.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RestResponse.java", RestResponse.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertThat", "com.jcabi.http.response.RestResponse", "org.hamcrest.Matcher", "matcher", "", "com.jcabi.http.response.RestResponse"), 98);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertStatus", "com.jcabi.http.response.RestResponse", "int", "status", "", "com.jcabi.http.response.RestResponse"), 114);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertStatus", "com.jcabi.http.response.RestResponse", "org.hamcrest.Matcher", "matcher", "", "com.jcabi.http.response.RestResponse"), 138);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertBody", "com.jcabi.http.response.RestResponse", "org.hamcrest.Matcher", "matcher", "", "com.jcabi.http.response.RestResponse"), 158);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertHeader", "com.jcabi.http.response.RestResponse", "java.lang.String:org.hamcrest.Matcher", "name:matcher", "", "com.jcabi.http.response.RestResponse"), 185);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertHeader", "com.jcabi.http.response.RestResponse", "java.lang.String:java.lang.String", "name:value", "", "com.jcabi.http.response.RestResponse"), 211);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jump", "com.jcabi.http.response.RestResponse", "java.net.URI", "uri", "", "com.jcabi.http.Request"), 222);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "follow", "com.jcabi.http.response.RestResponse", "", "", "", "com.jcabi.http.Request"), 247);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cookie", "com.jcabi.http.response.RestResponse", "java.lang.String", "name", "", "javax.ws.rs.core.Cookie"), 264);
        ajc$tjp_9 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.http.response.RestResponse", "com.jcabi.http.Response", "resp", ""), 87);
    }

    private static final class StatusMatch
    extends CustomMatcher<Response> {
        private final transient int status;

        StatusMatch(String msg, int sts) {
            super(msg);
            this.status = sts;
        }

        public boolean matches(Object resp) {
            return ((Response)Response.class.cast(resp)).status() == this.status;
        }
    }
}

