/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Blob;
import com.jcabi.github.Coordinates;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class MkBlob
implements Blob {
    private final transient MkStorage storage;
    private final transient Coordinates coords;
    private final transient String hash;

    MkBlob(MkStorage stg, String sha, Coordinates repo) {
        this.storage = stg;
        this.hash = sha;
        this.coords = repo;
    }

    @Override
    public String sha() {
        return this.hash;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/git/blobs/blob[sha='%s']", this.coords, this.sha());
    }

    public String toString() {
        return "MkBlob(storage=" + this.storage + ", coords=" + this.coords + ", hash=" + this.hash + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkBlob)) {
            return false;
        }
        MkBlob other = (MkBlob)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        String this$hash = this.hash;
        String other$hash = other.hash;
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        String $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }
}

