/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.json.JsonObject;

@Immutable
public interface Fork
extends JsonReadable,
JsonPatchable {
    public int number();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Fork {
        private final transient Fork fork;
        private final transient SmartJson jsn;

        public Smart(Fork frk) {
            this.fork = frk;
            this.jsn = new SmartJson(frk);
        }

        public String name() throws IOException {
            return this.jsn.text("name");
        }

        public String organization() throws IOException {
            return this.jsn.text("organization");
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String fullName() throws IOException {
            return this.jsn.text("full_name");
        }

        public String description() throws IOException {
            return this.jsn.text("description");
        }

        public URL htmlUrl() throws IOException {
            try {
                return new URI(this.jsn.text("html_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL cloneUrl() throws IOException {
            try {
                return new URI(this.jsn.text("clone_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String gitUrl() throws IOException {
            return this.jsn.text("git_url");
        }

        public String sshUrl() throws IOException {
            return this.jsn.text("ssh_url");
        }

        public URL svnUrl() throws IOException {
            try {
                return new URI(this.jsn.text("svn_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String mirrorUrl() throws IOException {
            return this.jsn.text("mirror_url");
        }

        public URL homeUrl() throws IOException {
            try {
                return new URI(this.jsn.text("homepage")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public int forks() throws IOException {
            return this.jsn.number("forks_count");
        }

        public int stargazers() throws IOException {
            return this.jsn.number("stargazers_count");
        }

        public int watchers() throws IOException {
            return this.jsn.number("watchers_count");
        }

        public int size() throws IOException {
            return this.jsn.number("size");
        }

        public String defaultBranch() throws IOException {
            return this.jsn.text("default_branch");
        }

        public int openIssues() throws IOException {
            return this.jsn.number("open_issues_count");
        }

        @Override
        public int number() {
            return this.fork.number();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.fork.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.fork.patch(json);
        }

        public String toString() {
            return "Fork.Smart(fork=" + this.fork + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Fork this$fork = this.fork;
            Fork other$fork = other.fork;
            if (this$fork == null ? other$fork != null : !this$fork.equals(other$fork)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Fork $fork = this.fork;
            result = result * 59 + ($fork == null ? 43 : $fork.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

