/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Blobs;
import com.jcabi.github.Commits;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Git;
import com.jcabi.github.References;
import com.jcabi.github.Repo;
import com.jcabi.github.Tags;
import com.jcabi.github.Trees;
import com.jcabi.github.mock.MkBlobs;
import com.jcabi.github.mock.MkCommits;
import com.jcabi.github.mock.MkReferences;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkTags;
import com.jcabi.github.mock.MkTrees;
import java.io.IOException;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkGit
implements Git {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkGit(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"git"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Blobs blobs() throws IOException {
        return new MkBlobs(this.storage, this.self, this.coords);
    }

    @Override
    public Commits commits() {
        try {
            return new MkCommits(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public References references() {
        try {
            return new MkReferences(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Tags tags() {
        try {
            return new MkTags(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Trees trees() {
        try {
            return new MkTrees(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return "MkGit(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkGit)) {
            return false;
        }
        MkGit other = (MkGit)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

