/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Label;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import com.jcabi.github.User;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.json.JsonObject;

@Immutable
public interface Event
extends Comparable<Event>,
JsonReadable {
    public static final String CLOSED = "closed";
    public static final String REOPENED = "reopened";
    public static final String SUBSCRIBED = "subscribed";
    public static final String MERGED = "merged";
    public static final String REFERENCED = "referenced";
    public static final String MENTIONED = "mentioned";
    public static final String ASSIGNED = "assigned";
    public static final String UNASSIGNED = "unassigned";
    public static final String LABELED = "labeled";
    public static final String UNLABELED = "unlabeled";
    public static final String MILESTONED = "milestoned";
    public static final String DEMILESTONED = "demilestoned";
    public static final String RENAMED = "renamed";
    public static final String LOCKED = "locked";
    public static final String UNLOCKED = "unlocked";
    public static final String HEAD_REF_DELETED = "head_ref_deleted";
    public static final String HEAD_REF_RESTORED = "head_ref_restored";

    public Repo repo();

    public int number();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Event {
        private final transient Event event;
        private final transient SmartJson jsn;

        public Smart(Event evt) {
            this.event = evt;
            this.jsn = new SmartJson(evt);
        }

        public boolean hasAuthor() throws IOException {
            return !this.event.json().isNull("actor");
        }

        public User author() throws IOException {
            return this.event.repo().github().users().get(this.event.json().getJsonObject("actor").getString("login"));
        }

        public String type() throws IOException {
            return this.jsn.text("event");
        }

        public URL url() throws IOException {
            return new URL(this.jsn.text("url"));
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Optional<Label> label() throws IOException {
            Optional lab = Optional.absent();
            JsonObject lbl = this.jsn.json().getJsonObject("label");
            if (lbl != null) {
                lab = Optional.of((Object)this.event.repo().labels().get(lbl.getString("name")));
            }
            return lab;
        }

        @Override
        public Repo repo() {
            return this.event.repo();
        }

        @Override
        public int number() {
            return this.event.number();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.event.json();
        }

        @Override
        public int compareTo(Event obj) {
            return this.event.compareTo(obj);
        }

        public String toString() {
            return "Event.Smart(event=" + this.event + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Event this$event = this.event;
            Event other$event = other.event;
            if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Event $event = this.event;
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

