/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Checks;
import com.jcabi.github.Commit;
import com.jcabi.github.Github;
import com.jcabi.github.Issue;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.MergeState;
import com.jcabi.github.PullComments;
import com.jcabi.github.PullRef;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import com.jcabi.github.User;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
public interface Pull
extends Comparable<Pull>,
JsonReadable,
JsonPatchable {
    public Repo repo();

    public int number();

    public PullRef base() throws IOException;

    public PullRef head() throws IOException;

    public Iterable<Commit> commits() throws IOException;

    public Iterable<JsonObject> files() throws IOException;

    public void merge(String var1) throws IOException;

    public MergeState merge(String var1, String var2) throws IOException;

    public PullComments comments() throws IOException;

    public Checks checks() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Pull {
        private final transient Pull pull;
        private final transient SmartJson jsn;

        public Smart(Pull pll) {
            this.pull = pll;
            this.jsn = new SmartJson(pll);
        }

        public boolean isOpen() throws IOException {
            return "open".equals(this.state());
        }

        public String state() throws IOException {
            return this.jsn.text("state");
        }

        public void state(String state) throws IOException {
            this.pull.patch(Json.createObjectBuilder().add("state", state).build());
        }

        public String title() throws IOException {
            return this.jsn.text("title");
        }

        public void title(String text) throws IOException {
            this.pull.patch(Json.createObjectBuilder().add("title", text).build());
        }

        public String body() throws IOException {
            return this.jsn.text("body");
        }

        public void body(String text) throws IOException {
            this.pull.patch(Json.createObjectBuilder().add("body", text).build());
        }

        public URL url() throws IOException {
            return new URL(this.jsn.text("url"));
        }

        public URL htmlUrl() throws IOException {
            return new URL(this.jsn.text("html_url"));
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date updatedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("updated_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date closedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("closed_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date mergedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("merged_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public User author() throws IOException {
            return this.pull.repo().github().users().get(this.jsn.value("user", JsonObject.class).getString("login"));
        }

        public Issue issue() {
            return this.pull.repo().issues().get(this.pull.number());
        }

        public int commentsCount() throws IOException {
            return this.jsn.number("comments");
        }

        @Override
        public Repo repo() {
            return this.pull.repo();
        }

        @Override
        public int number() {
            return this.pull.number();
        }

        @Override
        public Iterable<Commit> commits() throws IOException {
            return this.pull.commits();
        }

        @Override
        public Iterable<JsonObject> files() throws IOException {
            return this.pull.files();
        }

        @Override
        public void merge(String msg) throws IOException {
            this.pull.merge(msg);
        }

        @Override
        public MergeState merge(String msg, String sha) throws IOException {
            return this.pull.merge(msg, sha);
        }

        @Override
        public PullComments comments() throws IOException {
            return this.pull.comments();
        }

        @Override
        public Checks checks() throws IOException {
            return this.pull.checks();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.pull.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.pull.patch(json);
        }

        @Override
        public int compareTo(Pull obj) {
            return this.pull.compareTo(obj);
        }

        @Override
        public PullRef base() throws IOException {
            return this.pull.base();
        }

        @Override
        public PullRef head() throws IOException {
            return this.pull.head();
        }

        public String toString() {
            return "Pull.Smart(pull=" + this.pull + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Pull this$pull = this.pull;
            Pull other$pull = other.pull;
            if (this$pull == null ? other$pull != null : !this$pull.equals(other$pull)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pull $pull = this.pull;
            result = result * 59 + ($pull == null ? 43 : $pull.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

