/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
public interface Coordinates
extends Comparable<Coordinates> {
    public String user();

    public String repo();

    @Immutable
    public static final class Simple
    implements Coordinates {
        private final transient String usr;
        private final transient String rpo;

        public Simple(String user, String repo) {
            this.usr = user;
            this.rpo = repo;
        }

        public Simple(String mnemo) {
            String[] parts = mnemo.split("/", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(String.format("invalid coordinates '%s'", mnemo));
            }
            this.usr = parts[0];
            this.rpo = parts[1];
        }

        public String toString() {
            return String.format("%s/%s", this.usr, this.rpo);
        }

        @Override
        public String user() {
            return this.usr;
        }

        @Override
        public String repo() {
            return this.rpo;
        }

        @Override
        public int compareTo(Coordinates other) {
            return new CompareToBuilder().append((Object)this.usr, (Object)other.user()).append((Object)this.rpo, (Object)other.repo()).build();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            String this$usr = this.usr;
            String other$usr = other.usr;
            if (this$usr == null ? other$usr != null : !this$usr.equals(other$usr)) {
                return false;
            }
            String this$rpo = this.rpo;
            String other$rpo = other.rpo;
            return !(this$rpo == null ? other$rpo != null : !this$rpo.equals(other$rpo));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $usr = this.usr;
            result = result * 59 + ($usr == null ? 43 : $usr.hashCode());
            String $rpo = this.rpo;
            result = result * 59 + ($rpo == null ? 43 : $rpo.hashCode());
            return result;
        }
    }
}

