/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.GitHub;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAsset;
import com.jcabi.github.ReleaseAssets;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRelease;
import com.jcabi.github.mock.MkReleaseAsset;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkReleaseAssets
implements ReleaseAssets {
    private static final String ASSET_ID_XPATH = "/asset/id/text()";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int rel;

    MkReleaseAssets(MkStorage stg, String login, Coordinates rep, int number) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.rel = number;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']/releases/release[id='%d']", this.coords, this.rel)).addIf((Object)"assets"));
    }

    @Override
    public Release release() {
        return new MkRelease(this.storage, this.self, this.coords, this.rel);
    }

    @Override
    public Iterable<ReleaseAsset> iterate() {
        return new MkIterable<ReleaseAsset>(this.storage, this.xpath().concat("/asset"), xml -> this.get(Integer.parseInt((String)xml.xpath("id/text()").get(0))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseAsset upload(byte[] content, String type, String name) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(this.xpath().concat(ASSET_ID_XPATH)).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"asset").add((Object)"id").set((Object)Integer.toString(number)).up().add((Object)"name").set((Object)name).up().add((Object)"content").set((Object)DatatypeConverter.printBase64Binary((byte[])content)).up().add((Object)"content_type").set((Object)type).up().add((Object)"size").set((Object)Integer.toString(content.length)).up().add((Object)"download_count").set((Object)"42").up().add((Object)"created_at").set((Object)new GitHub.Time().toString()).up().add((Object)"updated_at").set((Object)new GitHub.Time().toString()).up().add((Object)"url").set((Object)"http://localhost/1").up().add((Object)"html_url").set((Object)"http://localhost/2").up());
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public ReleaseAsset get(int number) {
        return new MkReleaseAsset(this.storage, this.self, this.coords, this.rel, number);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/releases/release[id='%d']/assets", this.coords, this.rel);
    }

    @Generated
    public String toString() {
        return "MkReleaseAssets(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", rel=" + this.rel + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkReleaseAssets)) {
            return false;
        }
        MkReleaseAssets other = (MkReleaseAssets)o;
        if (this.rel != other.rel) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.rel;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

