/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAsset;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkRelease;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkReleaseAsset
implements ReleaseAsset {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int rel;
    private final transient int num;

    MkReleaseAsset(MkStorage stg, String login, Coordinates rep, int release, int asset) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.rel = release;
        this.num = asset;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public Release release() {
        return new MkRelease(this.storage, this.self, this.coords, this.rel);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void remove() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).strict(1).remove());
    }

    @Override
    public InputStream raw() throws IOException {
        return new ByteArrayInputStream(((String)this.storage.xml().xpath(this.xpath().concat("/content/text()")).get(0)).getBytes(StandardCharsets.UTF_8));
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkReleaseAsset other = (MkReleaseAsset)obj;
            result = this.rel == other.rel && this.num == other.num && this.storage.equals(other.storage) && this.coords.equals(other.coords);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.coords.hashCode();
        result = 31 * result + this.rel;
        result = 31 * result + this.num;
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/releases/release[id='%d']/assets/asset[id='%d']", this.coords, this.rel, this.num);
    }

    @Generated
    public String toString() {
        return "MkReleaseAsset(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", rel=" + this.rel + ", num=" + this.num + ")";
    }
}

