/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.GitHub;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComment;
import com.jcabi.github.PullComments;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkPullComment;
import com.jcabi.github.mock.MkStorage;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
final class MkPullComments
implements PullComments {
    private static final String COMMENT_ID_XPATH = "/comment/id/text()";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates repo;
    private final transient Pull owner;

    MkPullComments(MkStorage stg, String login, Coordinates rep, Pull pull) throws IOException {
        this.storage = stg;
        this.self = login;
        this.repo = rep;
        this.owner = pull;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']", this.repo, this.owner.number())).addIf((Object)"comments"));
    }

    @Override
    public Pull pull() {
        return this.owner;
    }

    @Override
    public PullComment get(int number) {
        return new MkPullComment(this.storage, this.repo, this.owner, number);
    }

    @Override
    public Iterable<PullComment> iterate(Map<String, String> params) {
        return new MkIterable<PullComment>(this.storage, String.format("/github/repos/repo[@coords='%s']/pulls/pull/comments", this.repo), xml -> this.get(Integer.parseInt((String)xml.xpath("comment/id/text()").get(0))));
    }

    @Override
    public Iterable<PullComment> iterate(int number, Map<String, String> params) {
        return new MkIterable<PullComment>(this.storage, this.xpath().concat("/comment"), xml -> this.get(Integer.parseInt((String)xml.xpath("id/text()").get(0))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PullComment post(String body, String commit, String path, int position) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().nodes(this.xpath().concat(COMMENT_ID_XPATH)).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"comment").add((Object)"id").set((Object)Integer.toString(number)).up().add((Object)"url").set((Object)"http://localhost/1").up().add((Object)"diff_hunk").set((Object)"@@ -16,33 +16,40 @@ public...").up().add((Object)"path").set((Object)path).up().add((Object)"position").set((Object)Integer.toString(position)).up().add((Object)"original_position").set((Object)Integer.toString(number)).up().add((Object)"commit_id").set((Object)commit).up().add((Object)"original_commit_id").set((Object)commit).up().add((Object)"body").set((Object)body).up().add((Object)"created_at").set((Object)new GitHub.Time().toString()).up().add((Object)"published_at").set((Object)new GitHub.Time().toString()).up().add((Object)"user").add((Object)"login").set((Object)this.self).up().add((Object)"pull_request_url").set((Object)"http://localhost/2").up());
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PullComment reply(String body, int comment) throws IOException {
        this.storage.lock();
        try {
            JsonObject orig = this.get(comment).json();
            PullComment reply = this.post(body, orig.getString("commit_id"), orig.getString("path"), comment);
            reply.patch(Json.createObjectBuilder().add("original_position", String.valueOf(comment)).build());
            PullComment pullComment = reply;
            return pullComment;
        }
        finally {
            this.storage.unlock();
        }
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath().concat(String.format("/comment[id='%d']", number))).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/comments", this.repo, this.owner.number());
    }

    @Generated
    public String toString() {
        return "MkPullComments(storage=" + this.storage + ", self=" + this.self + ", repo=" + this.repo + ", owner=" + this.owner + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPullComments)) {
            return false;
        }
        MkPullComments other = (MkPullComments)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        Pull this$owner = this.owner;
        Pull other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        Pull $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

