/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Limit;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtLimit
implements Limit {
    private final transient Request entry;
    private final transient GitHub ghub;
    private final transient String res;

    RtLimit(GitHub github, Request req, String name) {
        this.entry = req;
        this.ghub = github;
        this.res = name;
    }

    @Override
    public GitHub github() {
        return this.ghub;
    }

    @Override
    public JsonObject json() throws IOException {
        JsonObject json = new RtJson(this.entry).fetch().getJsonObject("resources");
        if (!json.containsKey((Object)this.res)) {
            throw new IllegalStateException(String.format("'%s' is absent in JSON: %s", this.res, json));
        }
        return json.getJsonObject(this.res);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtLimit)) {
            return false;
        }
        RtLimit other = (RtLimit)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        GitHub this$ghub = this.ghub;
        GitHub other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        String this$res = this.res;
        String other$res = other.res;
        return !(this$res == null ? other$res != null : !this$res.equals(other$res));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        GitHub $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        String $res = this.res;
        result = result * 59 + ($res == null ? 43 : $res.hashCode());
        return result;
    }
}

