/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtContent
implements Content {
    private final transient Request request;
    private final transient Repo owner;
    private final transient String location;

    RtContent(Request req, Repo repo, String path) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/contents").path(path).back();
        this.owner = repo;
        this.location = path;
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public String path() {
        return this.location;
    }

    @Override
    public int compareTo(Content other) {
        return this.path().compareTo(other.path());
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public InputStream raw() throws IOException {
        return new ByteArrayInputStream(((RestResponse)this.request.reset("Accept").header("Accept", (Object)"application/vnd.github.v3.raw").fetch().as(RestResponse.class)).assertStatus(200).binary());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtContent)) {
            return false;
        }
        RtContent other = (RtContent)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$location = this.location;
        String other$location = other.location;
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $location = this.location;
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }
}

