/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.CommitsComparison;
import com.jcabi.github.FileChange;
import com.jcabi.github.Repo;
import com.jcabi.github.RtFileChange;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtCommitsComparison
implements CommitsComparison {
    private final transient Request request;
    private final transient Repo owner;

    RtCommitsComparison(Request req, Repo repo, String base, String head) {
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().toString()).path("/compare").path(String.format("%s...%s", base, head)).back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Iterable<FileChange> files() throws IOException {
        return new FileChanges(this.json().getJsonArray("files"));
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtCommitsComparison)) {
            return false;
        }
        RtCommitsComparison other = (RtCommitsComparison)o;
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    @Loggable(value=1)
    private static final class FileChanges
    implements Iterable<FileChange> {
        private final transient List<JsonObject> list;

        FileChanges(JsonArray files) {
            this.list = files.getValuesAs(JsonObject.class);
        }

        @Override
        public Iterator<FileChange> iterator() {
            return new FileChangesIterator(this.list.iterator());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileChanges)) {
                return false;
            }
            FileChanges other = (FileChanges)o;
            List<JsonObject> this$list = this.list;
            List<JsonObject> other$list = other.list;
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JsonObject> $list = this.list;
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RtCommitsComparison.FileChanges(list=" + this.list + ")";
        }
    }

    private static final class FileChangesIterator
    implements Iterator<FileChange> {
        private final transient Iterator<JsonObject> iterator;

        FileChangesIterator(Iterator<JsonObject> iter) {
            this.iterator = iter;
        }

        @Override
        public FileChange next() {
            return new RtFileChange(this.iterator.next());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("#remove()");
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileChangesIterator)) {
                return false;
            }
            FileChangesIterator other = (FileChangesIterator)o;
            Iterator<JsonObject> this$iterator = this.iterator;
            Iterator<JsonObject> other$iterator = other.iterator;
            return !(this$iterator == null ? other$iterator != null : !this$iterator.equals(other$iterator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Iterator<JsonObject> $iterator = this.iterator;
            result = result * 59 + ($iterator == null ? 43 : $iterator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RtCommitsComparison.FileChangesIterator(iterator=" + this.iterator + ")";
        }
    }
}

