/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import com.jcabi.github.Reaction;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtComment
implements Comment {
    private static final String CONTENT = "content";
    private final transient Request request;
    private final transient Issue owner;
    private final transient long num;

    RtComment(Request req, Issue issue, long number) {
        Coordinates coords = issue.repo().coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/issues").path("/comments").path(Long.toString(number)).back();
        this.owner = issue;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Issue issue() {
        return this.owner;
    }

    @Override
    public long number() {
        return this.num;
    }

    @Override
    public void remove() throws IOException {
        ((RestResponse)this.request.method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public int compareTo(Comment comment) {
        return Long.compare(this.number(), comment.number());
    }

    @Override
    public void react(Reaction reaction) throws IOException {
        JsonObject json = Json.createObjectBuilder().add(CONTENT, reaction.type()).build();
        ((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(200);
    }

    @Override
    public Iterable<Reaction> reactions() {
        return new RtPagination<Reaction>(this.request.uri().path("/reactions").back(), object -> new Reaction.Simple(object.getString(CONTENT)));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtComment)) {
            return false;
        }
        RtComment other = (RtComment)o;
        if (this.num != other.num) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Issue this$owner = this.owner;
        Issue other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $num = this.num;
        result = result * 59 + (int)($num >>> 32 ^ $num);
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Issue $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

