/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.google.common.base.Charsets;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAsset;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkRelease;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.json.JsonObject;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkReleaseAsset
implements ReleaseAsset {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int rel;
    private final transient int num;

    MkReleaseAsset(MkStorage stg, String login, Coordinates rep, int release, int asset) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.rel = release;
        this.num = asset;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public Release release() {
        return new MkRelease(this.storage, this.self, this.coords, this.rel);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void remove() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).strict(1).remove());
    }

    @Override
    public InputStream raw() throws IOException {
        return new ByteArrayInputStream(((String)this.storage.xml().xpath(String.format("%s/content/text()", this.xpath())).get(0)).getBytes(Charsets.UTF_8));
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/releases/release[id='%d']/assets/asset[id='%d']", this.coords, this.rel, this.num);
    }

    public String toString() {
        return "MkReleaseAsset(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", rel=" + this.rel + ", num=" + this.num + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkReleaseAsset)) {
            return false;
        }
        MkReleaseAsset other = (MkReleaseAsset)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        if (this.rel != other.rel) {
            return false;
        }
        return this.num == other.num;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        result = result * 59 + this.rel;
        result = result * 59 + this.num;
        return result;
    }
}

