/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Github;
import com.jcabi.github.IssueEvents;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkEvent;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import java.io.IOException;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkIssueEvents
implements IssueEvents {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkIssueEvents(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"issue-events"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Event get(int number) {
        return new MkEvent(this.storage, this.self, this.coords, number);
    }

    @Override
    public Iterable<Event> iterate() {
        return new MkIterable<Event>(this.storage, String.format("%s/issue-event", this.xpath()), new MkIterable.Mapping<Event>(){

            @Override
            public Event map(XML xml) {
                return MkIssueEvents.this.get(Integer.parseInt((String)xml.xpath("number/text()").get(0)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event create(String type, int issue, String login, Optional<String> label) throws IOException {
        int number;
        String created = new Github.Time().toString();
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/issue-event/number/text()", this.xpath())).size();
            Directives directives = new Directives().xpath((Object)this.xpath()).add((Object)"issue-event").add((Object)"issue").set((Object)Integer.toString(issue)).up().add((Object)"number").set((Object)Integer.toString(number)).up().add((Object)"event").set((Object)type).up().add((Object)"created_at").set((Object)created).up().add((Object)"login").set((Object)login).up();
            if (label.isPresent()) {
                directives = directives.add((Object)"label").set(label.get()).up();
            }
            this.storage.apply((Iterable<Directive>)directives);
        }
        finally {
            this.storage.unlock();
        }
        Logger.info(MkEvent.class, (String)"issue event #%d of type %s created in %s for issue #%d by %s", (Object[])new Object[]{number, type, this.self, issue, login});
        return this.get(number);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issue-events", this.coords);
    }

    public String toString() {
        return "MkIssueEvents(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkIssueEvents)) {
            return false;
        }
        MkIssueEvents other = (MkIssueEvents)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

