/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Repo;
import com.jcabi.github.Repos;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtRepo;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtRepos
implements Repos {
    private final transient Github ghub;
    private final transient Request entry;

    RtRepos(Github github, Request req) {
        this.ghub = github;
        this.entry = req;
    }

    public String toString() {
        return this.entry.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public Repo create(Repos.RepoCreate settings) throws IOException {
        String uriPath = "user/repos";
        String org = settings.organization();
        if (org != null && !org.isEmpty()) {
            uriPath = "/orgs/".concat(org).concat("/repos");
        }
        return this.get(new Coordinates.Simple(((JsonResponse)((RestResponse)this.entry.uri().path(uriPath).back().method("POST").body().set((JsonStructure)settings.json()).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getString("full_name")));
    }

    @Override
    public Repo get(Coordinates name) {
        return new RtRepo(this.ghub, this.entry, name);
    }

    @Override
    public void remove(Coordinates coords) throws IOException {
        ((RestResponse)this.entry.uri().path("/repos").back().method("DELETE").uri().path(coords.toString()).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public Iterable<Repo> iterate(String identifier) {
        return new RtPagination<Repo>(this.entry.uri().queryParam("since", (Object)identifier).back(), new RtValuePagination.Mapping<Repo, JsonObject>(){

            @Override
            public Repo map(JsonObject object) {
                return RtRepos.this.get(new Coordinates.Simple(object.getString("full_name")));
            }
        });
    }

    @Override
    public boolean exists(Coordinates coords) throws IOException {
        String repo = coords.user().concat("/").concat(coords.repo());
        RestResponse response = (RestResponse)this.entry.uri().path("/repos/".concat(repo)).back().method("GET").fetch().as(RestResponse.class);
        return response.status() == 200;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtRepos)) {
            return false;
        }
        RtRepos other = (RtRepos)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        return !(this$entry == null ? other$entry != null : !this$entry.equals(other$entry));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        return result;
    }
}

