/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Hook;
import com.jcabi.github.Hooks;
import com.jcabi.github.Repo;
import com.jcabi.github.RtHook;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtHooks
implements Hooks {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    public RtHooks(Request req, Repo repo) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/hooks").back();
        this.owner = repo;
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Iterable<Hook> iterate() {
        return new RtPagination<Hook>(this.request, new RtValuePagination.Mapping<Hook, JsonObject>(){

            @Override
            public Hook map(JsonObject object) {
                return RtHooks.this.get(object.getInt("id"));
            }
        });
    }

    @Override
    public void remove(int number) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(Integer.toString(number)).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public Hook get(int number) {
        return new RtHook(this.entry, this.owner, number);
    }

    @Override
    public Hook create(String name, Map<String, String> config, Iterable<Event> events, boolean active) throws IOException {
        JsonObjectBuilder configs = Json.createObjectBuilder();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            configs.add(entry.getKey(), entry.getValue());
        }
        JsonArrayBuilder evnts = Json.createArrayBuilder();
        for (Event event : events) {
            evnts.add(event.toString());
        }
        JsonObject jsonObject = Json.createObjectBuilder().add("name", name).add("config", configs).add("active", active).add("events", evnts).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)jsonObject).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtHooks)) {
            return false;
        }
        RtHooks other = (RtHooks)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

