/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Blobs;
import com.jcabi.github.Commits;
import com.jcabi.github.Git;
import com.jcabi.github.References;
import com.jcabi.github.Repo;
import com.jcabi.github.RtBlobs;
import com.jcabi.github.RtCommits;
import com.jcabi.github.RtReferences;
import com.jcabi.github.RtTags;
import com.jcabi.github.RtTrees;
import com.jcabi.github.Tags;
import com.jcabi.github.Trees;
import com.jcabi.http.Request;
import java.io.IOException;

@Immutable
@Loggable(value=1)
final class RtGit
implements Git {
    private final transient Repo owner;
    private final transient Request entry;

    public RtGit(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Blobs blobs() throws IOException {
        return new RtBlobs(this.entry, this.repo());
    }

    @Override
    public Commits commits() {
        return new RtCommits(this.entry, this.owner);
    }

    @Override
    public References references() {
        return new RtReferences(this.entry, this.owner);
    }

    @Override
    public Tags tags() {
        return new RtTags(this.entry, this.owner);
    }

    @Override
    public Trees trees() {
        return new RtTrees(this.entry, this.repo());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtGit)) {
            return false;
        }
        RtGit other = (RtGit)o;
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

